/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_In;
import androidx.camera.core.imagecapture.NoMetadataImageReader;
import androidx.camera.core.imagecapture.PostviewSettings;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureCallbacks;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.Node;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class CaptureNode
implements Node<In, ProcessingNode.In> {
    private static final String TAG = "CaptureNode";
    @VisibleForTesting
    static final int MAX_IMAGES = 4;
    ProcessingRequest mCurrentRequest = null;
    @Nullable SafeCloseImageReaderProxy mSafeCloseImageReaderProxy;
    @Nullable SafeCloseImageReaderProxy mSecondarySafeCloseImageReaderProxy;
    @Nullable SafeCloseImageReaderProxy mSafeCloseImageReaderForPostview;
    private  @Nullable ProcessingNode.In mOutputEdge;
    private @Nullable In mInputEdge;
    private @Nullable NoMetadataImageReader mNoMetadataImageReader = null;

    CaptureNode() {
    }

    @Override
    public  @NonNull ProcessingNode.In transform(@NonNull In inputEdge) {
        Consumer requestConsumer;
        ImageReaderProxy wrappedImageReader;
        CameraCaptureCallback cameraCaptureCallbacks;
        boolean isSimultaneousCaptureEnabled;
        Preconditions.checkState((this.mInputEdge == null && this.mSafeCloseImageReaderProxy == null ? 1 : 0) != 0, (String)"CaptureNode does not support recreation yet.");
        this.mInputEdge = inputEdge;
        Size size = inputEdge.getSize();
        int format = inputEdge.getInputFormat();
        ImageReaderProxy secondaryWrappedImageReader = null;
        boolean hasMetadata = !inputEdge.isVirtualCamera();
        CameraCaptureCallback progressCallback = new CameraCaptureCallback(){

            @Override
            public void onCaptureStarted(int captureConfigId) {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    if (CaptureNode.this.mCurrentRequest != null) {
                        CaptureNode.this.mCurrentRequest.onCaptureStarted();
                    }
                });
            }

            @Override
            public void onCaptureProcessProgressed(int captureConfigId, int progress) {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    if (CaptureNode.this.mCurrentRequest != null) {
                        CaptureNode.this.mCurrentRequest.onCaptureProcessProgressed(progress);
                    }
                });
            }
        };
        CameraCaptureCallback secondaryCameraCaptureCallback = null;
        boolean bl = isSimultaneousCaptureEnabled = inputEdge.getOutputFormats().size() > 1;
        if (hasMetadata && inputEdge.getImageReaderProxyProvider() == null) {
            MetadataImageReader metadataImageReader;
            if (isSimultaneousCaptureEnabled) {
                metadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), 256, 4);
                cameraCaptureCallbacks = CameraCaptureCallbacks.createComboCallback(progressCallback, metadataImageReader.getCameraCaptureCallback());
                wrappedImageReader = metadataImageReader;
                MetadataImageReader secondaryMetadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), 32, 4);
                secondaryCameraCaptureCallback = CameraCaptureCallbacks.createComboCallback(progressCallback, secondaryMetadataImageReader.getCameraCaptureCallback());
                secondaryWrappedImageReader = secondaryMetadataImageReader;
            } else {
                metadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), format, 4);
                cameraCaptureCallbacks = CameraCaptureCallbacks.createComboCallback(progressCallback, metadataImageReader.getCameraCaptureCallback());
                wrappedImageReader = metadataImageReader;
            }
            requestConsumer = this::onRequestAvailable;
        } else {
            cameraCaptureCallbacks = progressCallback;
            wrappedImageReader = this.mNoMetadataImageReader = new NoMetadataImageReader(CaptureNode.createImageReaderProxy(inputEdge.getImageReaderProxyProvider(), size.getWidth(), size.getHeight(), format));
            requestConsumer = request -> {
                this.onRequestAvailable((ProcessingRequest)request);
                this.mNoMetadataImageReader.acceptProcessingRequest((ProcessingRequest)request);
            };
        }
        inputEdge.setCameraCaptureCallback(cameraCaptureCallbacks);
        if (isSimultaneousCaptureEnabled && secondaryCameraCaptureCallback != null) {
            inputEdge.setSecondaryCameraCaptureCallback(secondaryCameraCaptureCallback);
        }
        inputEdge.setSurface(Objects.requireNonNull(wrappedImageReader.getSurface()));
        this.mSafeCloseImageReaderProxy = new SafeCloseImageReaderProxy(wrappedImageReader);
        this.setOnImageAvailableListener(wrappedImageReader);
        PostviewSettings postviewSettings = inputEdge.getPostviewSettings();
        if (postviewSettings != null) {
            ImageReaderProxy postviewImageReader = CaptureNode.createImageReaderProxy(inputEdge.getImageReaderProxyProvider(), postviewSettings.getResolution().getWidth(), postviewSettings.getResolution().getHeight(), postviewSettings.getInputFormat());
            postviewImageReader.setOnImageAvailableListener(imageReader -> {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        this.propagatePostviewImage(image);
                    }
                }
                catch (IllegalStateException e) {
                    Logger.e(TAG, "Failed to acquire latest image of postview", e);
                }
            }, CameraXExecutors.mainThreadExecutor());
            this.mSafeCloseImageReaderForPostview = new SafeCloseImageReaderProxy(postviewImageReader);
            inputEdge.setPostviewSurface(postviewImageReader.getSurface(), postviewSettings.getResolution(), postviewSettings.getInputFormat());
        }
        if (isSimultaneousCaptureEnabled && secondaryWrappedImageReader != null) {
            inputEdge.setSecondarySurface(secondaryWrappedImageReader.getSurface());
            this.mSecondarySafeCloseImageReaderProxy = new SafeCloseImageReaderProxy(secondaryWrappedImageReader);
            this.setOnImageAvailableListener(secondaryWrappedImageReader);
        }
        inputEdge.getRequestEdge().setListener((Consumer<ProcessingRequest>)requestConsumer);
        inputEdge.getErrorEdge().setListener((Consumer<TakePictureManager.CaptureError>)((Consumer)this::sendCaptureError));
        this.mOutputEdge = ProcessingNode.In.of(inputEdge.getInputFormat(), inputEdge.getOutputFormats());
        return this.mOutputEdge;
    }

    private static @NonNull ImageReaderProxy createImageReaderProxy(@Nullable ImageReaderProxyProvider imageReaderProxyProvider, int width, int height, int format) {
        if (imageReaderProxyProvider != null) {
            return imageReaderProxyProvider.newInstance(width, height, format, 4, 0L);
        }
        return ImageReaderProxys.createIsolatedReader(width, height, format, 4);
    }

    private void setOnImageAvailableListener(@NonNull ImageReaderProxy imageReaderProxy) {
        imageReaderProxy.setOnImageAvailableListener(imageReader -> {
            block5: {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        this.onImageProxyAvailable(image);
                    } else if (this.mCurrentRequest != null) {
                        this.sendCaptureError(TakePictureManager.CaptureError.of(this.mCurrentRequest.getRequestId(), new ImageCaptureException(2, "Failed to acquire latest image", null)));
                    }
                }
                catch (IllegalStateException e) {
                    if (this.mCurrentRequest == null) break block5;
                    this.sendCaptureError(TakePictureManager.CaptureError.of(this.mCurrentRequest.getRequestId(), new ImageCaptureException(2, "Failed to acquire latest image", e)));
                }
            }
        }, CameraXExecutors.mainThreadExecutor());
    }

    @VisibleForTesting
    @MainThread
    void onImageProxyAvailable(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mCurrentRequest == null) {
            Logger.w(TAG, "Discarding ImageProxy which was inadvertently acquired: " + imageProxy);
            imageProxy.close();
        } else {
            Integer stageId = (Integer)imageProxy.getImageInfo().getTagBundle().getTag(this.mCurrentRequest.getTagBundleKey());
            if (stageId == null) {
                Logger.w(TAG, "Discarding ImageProxy which was acquired for aborted request");
                imageProxy.close();
                return;
            }
            this.matchAndPropagateImage(imageProxy);
        }
    }

    @MainThread
    private void matchAndPropagateImage(@NonNull ImageProxy imageProxy) {
        boolean isProcessed;
        boolean isSimultaneousCaptureEnabled;
        Threads.checkMainThread();
        Objects.requireNonNull(this.mOutputEdge).getEdge().accept(ProcessingNode.InputPacket.of(this.mCurrentRequest, imageProxy));
        ProcessingRequest request = this.mCurrentRequest;
        boolean bl = isSimultaneousCaptureEnabled = this.mInputEdge != null && this.mInputEdge.getOutputFormats().size() > 1;
        if (isSimultaneousCaptureEnabled && this.mCurrentRequest != null) {
            this.mCurrentRequest.getTakePictureRequest().markFormatProcessStatusInSimultaneousCapture(imageProxy.getFormat(), true);
        }
        boolean bl2 = isProcessed = !isSimultaneousCaptureEnabled || this.mCurrentRequest != null && this.mCurrentRequest.getTakePictureRequest().isFormatProcessedInSimultaneousCapture();
        if (isProcessed) {
            this.mCurrentRequest = null;
        }
        request.onImageCaptured();
    }

    private void propagatePostviewImage(@NonNull ImageProxy imageProxy) {
        if (this.mCurrentRequest == null) {
            Logger.w(TAG, "Postview image is closed due to request completed or aborted");
            imageProxy.close();
            return;
        }
        Objects.requireNonNull(this.mOutputEdge).getPostviewEdge().accept(ProcessingNode.InputPacket.of(this.mCurrentRequest, imageProxy));
    }

    @VisibleForTesting
    @MainThread
    void onRequestAvailable(final @NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        Preconditions.checkState((request.getStageIds().size() == 1 ? 1 : 0) != 0, (String)"only one capture stage is supported.");
        Preconditions.checkState((this.getCapacity() > 0 ? 1 : 0) != 0, (String)"Too many acquire images. Close image to be able to process next.");
        this.mCurrentRequest = request;
        Futures.addCallback(request.getCaptureFuture(), new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                Threads.checkMainThread();
                if (request == CaptureNode.this.mCurrentRequest) {
                    Logger.w(CaptureNode.TAG, "request aborted, id=" + CaptureNode.this.mCurrentRequest.getRequestId());
                    if (CaptureNode.this.mNoMetadataImageReader != null) {
                        CaptureNode.this.mNoMetadataImageReader.clearProcessingRequest();
                    }
                    CaptureNode.this.mCurrentRequest = null;
                }
            }
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    void sendCaptureError( @NonNull TakePictureManager.CaptureError error) {
        Threads.checkMainThread();
        if (this.mCurrentRequest != null && this.mCurrentRequest.getRequestId() == error.getRequestId()) {
            this.mCurrentRequest.onCaptureFailure(error.getImageCaptureException());
        }
    }

    @Override
    @MainThread
    public void release() {
        Threads.checkMainThread();
        this.releaseInputResources(Objects.requireNonNull(this.mInputEdge), Objects.requireNonNull(this.mSafeCloseImageReaderProxy), this.mSecondarySafeCloseImageReaderProxy, this.mSafeCloseImageReaderForPostview);
    }

    private void releaseInputResources(@NonNull In inputEdge, @NonNull SafeCloseImageReaderProxy imageReader, @Nullable SafeCloseImageReaderProxy secondaryImageReader, @Nullable SafeCloseImageReaderProxy imageReaderForPostview) {
        inputEdge.getSurface().close();
        inputEdge.getSurface().getTerminationFuture().addListener(() -> imageReader.safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
        if (inputEdge.getPostviewSurface() != null) {
            inputEdge.getPostviewSurface().close();
            inputEdge.getPostviewSurface().getTerminationFuture().addListener(() -> {
                if (imageReaderForPostview != null) {
                    imageReaderForPostview.safeClose();
                }
            }, (Executor)CameraXExecutors.mainThreadExecutor());
        }
        if (inputEdge.getOutputFormats().size() > 1 && inputEdge.getSecondarySurface() != null) {
            inputEdge.getSecondarySurface().close();
            inputEdge.getSecondarySurface().getTerminationFuture().addListener(() -> {
                if (secondaryImageReader != null) {
                    secondaryImageReader.safeClose();
                }
            }, (Executor)CameraXExecutors.mainThreadExecutor());
        }
    }

    @VisibleForTesting
    @NonNull In getInputEdge() {
        return Objects.requireNonNull(this.mInputEdge);
    }

    @VisibleForTesting
    public @NonNull SafeCloseImageReaderProxy getSafeCloseImageReaderProxy() {
        return Objects.requireNonNull(this.mSafeCloseImageReaderProxy);
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        return this.mSafeCloseImageReaderProxy.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        this.mSafeCloseImageReaderProxy.setOnImageCloseListener(listener);
    }

    @AutoValue
    static abstract class In {
        private @NonNull CameraCaptureCallback mCameraCaptureCallback = new CameraCaptureCallback(){};
        private @Nullable CameraCaptureCallback mSecondaryCameraCaptureCallback;
        private @Nullable DeferrableSurface mSurface;
        private @Nullable DeferrableSurface mSecondarySurface;
        private @Nullable DeferrableSurface mPostviewSurface = null;

        In() {
        }

        abstract @NonNull Size getSize();

        abstract int getInputFormat();

        abstract @NonNull List<Integer> getOutputFormats();

        abstract boolean isVirtualCamera();

        abstract @Nullable ImageReaderProxyProvider getImageReaderProxyProvider();

        abstract @Nullable PostviewSettings getPostviewSettings();

        abstract @NonNull Edge<ProcessingRequest> getRequestEdge();

        abstract @NonNull Edge<TakePictureManager.CaptureError> getErrorEdge();

        @NonNull DeferrableSurface getSurface() {
            return Objects.requireNonNull(this.mSurface);
        }

        @Nullable DeferrableSurface getPostviewSurface() {
            return this.mPostviewSurface;
        }

        @Nullable DeferrableSurface getSecondarySurface() {
            return this.mSecondarySurface;
        }

        void setSurface(@NonNull Surface surface) {
            Preconditions.checkState((this.mSurface == null ? 1 : 0) != 0, (String)"The surface is already set.");
            this.mSurface = new ImmediateSurface(surface, this.getSize(), this.getInputFormat());
        }

        void setPostviewSurface(@NonNull Surface surface, @NonNull Size size, int imageFormat) {
            this.mPostviewSurface = new ImmediateSurface(surface, size, imageFormat);
        }

        void setSecondarySurface(@NonNull Surface surface) {
            Preconditions.checkState((this.mSecondarySurface == null ? 1 : 0) != 0, (String)"The secondary surface is already set.");
            this.mSecondarySurface = new ImmediateSurface(surface, this.getSize(), this.getInputFormat());
        }

        @NonNull CameraCaptureCallback getCameraCaptureCallback() {
            return this.mCameraCaptureCallback;
        }

        void setCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCameraCaptureCallback = cameraCaptureCallback;
        }

        @Nullable CameraCaptureCallback getSecondaryCameraCaptureCallback() {
            return this.mSecondaryCameraCaptureCallback;
        }

        void setSecondaryCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mSecondaryCameraCaptureCallback = cameraCaptureCallback;
        }

        static @NonNull In of(@NonNull Size size, int inputFormat, @NonNull List<Integer> outputFormats, boolean isVirtualCamera, @Nullable ImageReaderProxyProvider imageReaderProxyProvider) {
            return new AutoValue_CaptureNode_In(size, inputFormat, outputFormats, isVirtualCamera, imageReaderProxyProvider, null, new Edge<ProcessingRequest>(), new Edge<TakePictureManager.CaptureError>());
        }

        static @NonNull In of(@NonNull Size size, int inputFormat, @NonNull List<Integer> outputFormats, boolean isVirtualCamera, @Nullable ImageReaderProxyProvider imageReaderProxyProvider, @Nullable PostviewSettings postviewSettings) {
            return new AutoValue_CaptureNode_In(size, inputFormat, outputFormats, isVirtualCamera, imageReaderProxyProvider, postviewSettings, new Edge<ProcessingRequest>(), new Edge<TakePictureManager.CaptureError>());
        }
    }
}

