/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.featuregroup.impl.resolver;

import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.ResolvedFeatureGroup;
import androidx.camera.core.featuregroup.impl.UseCaseType;
import androidx.camera.core.featuregroup.impl.feature.DynamicRangeFeature;
import androidx.camera.core.featuregroup.impl.feature.FpsRangeFeature;
import androidx.camera.core.featuregroup.impl.feature.ImageFormatFeature;
import androidx.camera.core.featuregroup.impl.feature.VideoStabilizationFeature;
import androidx.camera.core.featuregroup.impl.resolver.FeatureGroupResolutionResult;
import androidx.camera.core.featuregroup.impl.resolver.FeatureGroupResolver;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/camera/core/featuregroup/impl/resolver/DefaultFeatureGroupResolver;", "Landroidx/camera/core/featuregroup/impl/resolver/FeatureGroupResolver;", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "<init>", "(Landroidx/camera/core/impl/CameraInfoInternal;)V", "resolveFeatureGroup", "Landroidx/camera/core/featuregroup/impl/resolver/FeatureGroupResolutionResult;", "sessionConfig", "Landroidx/camera/core/SessionConfig;", "getFeatureListResolvedByPriority", "orderedPreferredFeatures", "", "Landroidx/camera/core/featuregroup/GroupableFeature;", "index", "", "currentOptionalFeatures", "Companion", "camera-core_release"})
@SourceDebugExtension(value={"SMAP\nDefaultFeatureGroupResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFeatureGroupResolver.kt\nandroidx/camera/core/featuregroup/impl/resolver/DefaultFeatureGroupResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1755#2,3:193\n1755#2,3:196\n1863#2,2:199\n1863#2,2:201\n774#2:203\n865#2,2:204\n*S KotlinDebug\n*F\n+ 1 DefaultFeatureGroupResolver.kt\nandroidx/camera/core/featuregroup/impl/resolver/DefaultFeatureGroupResolver\n*L\n77#1:193,3\n78#1:196,3\n81#1:199,2\n89#1:201,2\n114#1:203\n114#1:204,2\n*E\n"})
public final class DefaultFeatureGroupResolver
implements FeatureGroupResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CameraInfoInternal cameraInfoInternal;
    @NotNull
    private static final String TAG = "DefaultFeatureGroupResolver";

    public DefaultFeatureGroupResolver(@NotNull CameraInfoInternal cameraInfoInternal) {
        Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
        this.cameraInfoInternal = cameraInfoInternal;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FeatureGroupResolutionResult resolveFeatureGroup(@NotNull SessionConfig sessionConfig) {
        void $this$filterTo$iv$iv;
        Object element$iv3;
        boolean bl;
        boolean supportsImageFeature;
        List<GroupableFeature> orderedPreferredFeatures;
        Set<GroupableFeature> requiredFeatures;
        List<UseCase> useCases;
        block12: {
            boolean bl2;
            block11: {
                Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
                useCases = sessionConfig.getUseCases();
                requiredFeatures = sessionConfig.getRequiredFeatureGroup();
                orderedPreferredFeatures = sessionConfig.getPreferredFeatureGroup();
                if (!(!((Collection)requiredFeatures).isEmpty() || !((Collection)orderedPreferredFeatures).isEmpty())) {
                    boolean $i$a$-require-DefaultFeatureGroupResolver$resolveFeatureGroup$22 = false;
                    String $i$a$-require-DefaultFeatureGroupResolver$resolveFeatureGroup$22 = "Must have at least one required or preferred feature";
                    throw new IllegalArgumentException($i$a$-require-DefaultFeatureGroupResolver$resolveFeatureGroup$22.toString());
                }
                Iterable $this$any$iv = useCases;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        UseCase it = (UseCase)element$iv2;
                        boolean bl3 = false;
                        if (!(it instanceof ImageCapture)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            supportsImageFeature = bl2;
            Iterable $this$any$iv = useCases;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    UseCase it = (UseCase)element$iv3;
                    boolean bl4 = false;
                    if (!(it instanceof Preview || CameraUseCaseAdapter.isVideoCapture(it))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        boolean supportsStreamFeature = bl;
        Iterable $this$forEach$iv = useCases;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            UseCase it = (UseCase)element$iv3;
            boolean bl5 = false;
            UseCaseType useCaseType = UseCaseType.Companion.getFeatureGroupUseCaseType(it);
            if (useCaseType != UseCaseType.UNDEFINED) continue;
            return new FeatureGroupResolutionResult.UnsupportedUseCase(it);
        }
        $this$forEach$iv = requiredFeatures;
        $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            GroupableFeature feature = (GroupableFeature)element$iv3;
            boolean bl6 = false;
            GroupableFeature groupableFeature = feature;
            if (groupableFeature instanceof ImageFormatFeature) {
                if (supportsImageFeature) continue;
                return new FeatureGroupResolutionResult.UseCaseMissing(UseCaseType.IMAGE_CAPTURE.toString(), feature);
            }
            if (!(groupableFeature instanceof DynamicRangeFeature) && !(groupableFeature instanceof FpsRangeFeature) && !(groupableFeature instanceof VideoStabilizationFeature) || supportsStreamFeature) continue;
            return new FeatureGroupResolutionResult.UseCaseMissing((Object)((Object)UseCaseType.PREVIEW) + " or " + (Object)((Object)UseCaseType.VIDEO_CAPTURE), feature);
        }
        Iterable $this$filter$iv = orderedPreferredFeatures;
        boolean $i$f$filter = false;
        element$iv3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GroupableFeature feature = (GroupableFeature)element$iv$iv;
            boolean bl7 = false;
            boolean bl8 = feature instanceof ImageFormatFeature ? supportsImageFeature : true;
            if (!bl8) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPreferredFeatures = (List)destination$iv$iv;
        return DefaultFeatureGroupResolver.getFeatureListResolvedByPriority$default(this, sessionConfig, filteredPreferredFeatures, 0, null, 12, null);
    }

    private final FeatureGroupResolutionResult getFeatureListResolvedByPriority(SessionConfig sessionConfig, List<? extends GroupableFeature> orderedPreferredFeatures, int index, List<? extends GroupableFeature> currentOptionalFeatures) {
        if (index >= orderedPreferredFeatures.size()) {
            Set features = SetsKt.plus(sessionConfig.getRequiredFeatureGroup(), (Iterable)currentOptionalFeatures);
            Logger.d(TAG, "getFeatureListResolvedByPriority: features = " + features + ", useCases = " + sessionConfig.getUseCases());
            return this.cameraInfoInternal.isResolvedFeatureGroupSupported(new ResolvedFeatureGroup(features), sessionConfig) ? (FeatureGroupResolutionResult)new FeatureGroupResolutionResult.Supported(new ResolvedFeatureGroup(features)) : (FeatureGroupResolutionResult)FeatureGroupResolutionResult.Unsupported.INSTANCE;
        }
        FeatureGroupResolutionResult resultTakingCurrentFeature = this.getFeatureListResolvedByPriority(sessionConfig, orderedPreferredFeatures, index + 1, CollectionsKt.plus((Collection)currentOptionalFeatures, (Object)orderedPreferredFeatures.get(index)));
        if (resultTakingCurrentFeature instanceof FeatureGroupResolutionResult.Supported) {
            return resultTakingCurrentFeature;
        }
        return this.getFeatureListResolvedByPriority(sessionConfig, orderedPreferredFeatures, index + 1, currentOptionalFeatures);
    }

    static /* synthetic */ FeatureGroupResolutionResult getFeatureListResolvedByPriority$default(DefaultFeatureGroupResolver defaultFeatureGroupResolver, SessionConfig sessionConfig, List list, int n, List list2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return defaultFeatureGroupResolver.getFeatureListResolvedByPriority(sessionConfig, list, n, list2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/camera/core/featuregroup/impl/resolver/DefaultFeatureGroupResolver$Companion;", "", "<init>", "()V", "TAG", "", "camera-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

