/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.featuregroup.impl.feature;

import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.feature.FeatureTypeInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Landroidx/camera/core/featuregroup/impl/feature/DynamicRangeFeature;", "Landroidx/camera/core/featuregroup/GroupableFeature;", "dynamicRange", "Landroidx/camera/core/DynamicRange;", "<init>", "(Landroidx/camera/core/DynamicRange;)V", "getDynamicRange", "()Landroidx/camera/core/DynamicRange;", "featureTypeInternal", "Landroidx/camera/core/featuregroup/impl/feature/FeatureTypeInternal;", "getFeatureTypeInternal$camera_core_release", "()Landroidx/camera/core/featuregroup/impl/feature/FeatureTypeInternal;", "isSupportedIndividually", "", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "sessionConfig", "Landroidx/camera/core/SessionConfig;", "toString", "", "Companion", "camera-core_release"})
public final class DynamicRangeFeature
extends GroupableFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DynamicRange dynamicRange;
    @NotNull
    private final FeatureTypeInternal featureTypeInternal;
    @NotNull
    private static final String TAG = "DynamicRangeFeature";
    @JvmField
    @NotNull
    public static final DynamicRange DEFAULT_DYNAMIC_RANGE;

    public DynamicRangeFeature(@NotNull DynamicRange dynamicRange) {
        Intrinsics.checkNotNullParameter((Object)dynamicRange, (String)"dynamicRange");
        this.dynamicRange = dynamicRange;
        this.featureTypeInternal = FeatureTypeInternal.DYNAMIC_RANGE;
    }

    @NotNull
    public final DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    @Override
    @NotNull
    public FeatureTypeInternal getFeatureTypeInternal$camera_core_release() {
        return this.featureTypeInternal;
    }

    @Override
    public boolean isSupportedIndividually(@NotNull CameraInfoInternal cameraInfoInternal, @NotNull SessionConfig sessionConfig) {
        Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Set<DynamicRange> set = cameraInfoInternal.getSupportedDynamicRanges();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getSupportedDynamicRanges(...)");
        Set<DynamicRange> cameraInfoSupportedDynamicRanges = set;
        Logger.d(TAG, "isSupportedIndividually: cameraInfoSupportedDynamicRanges = " + cameraInfoSupportedDynamicRanges + ", this = " + this);
        if (!cameraInfoSupportedDynamicRanges.contains(this.dynamicRange)) {
            return false;
        }
        for (UseCase useCase : sessionConfig.getUseCases()) {
            Set<DynamicRange> useCaseSupportedDynamicRanges = useCase.getSupportedDynamicRanges(cameraInfoInternal);
            Logger.d(TAG, "isSupportedIndividually: useCaseSupportedDynamicRanges = " + useCaseSupportedDynamicRanges + ", this = " + this + ", useCases = " + useCase);
            if (useCaseSupportedDynamicRanges == null || useCaseSupportedDynamicRanges.contains(this.dynamicRange)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "DynamicRangeFeature(dynamicRange=" + this.dynamicRange + ')';
    }

    static {
        DynamicRange dynamicRange = DynamicRange.SDR;
        Intrinsics.checkNotNullExpressionValue((Object)dynamicRange, (String)"SDR");
        DEFAULT_DYNAMIC_RANGE = dynamicRange;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/camera/core/featuregroup/impl/feature/DynamicRangeFeature$Companion;", "", "<init>", "()V", "TAG", "", "DEFAULT_DYNAMIC_RANGE", "Landroidx/camera/core/DynamicRange;", "Lorg/jspecify/annotations/NonNull;", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

