/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.featuregroup.impl;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.view.SurfaceHolder;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.featuregroup.impl.feature.FeatureTypeInternal;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.core.streamsharing.StreamSharing;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u0011\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0017"}, d2={"Landroidx/camera/core/featuregroup/impl/UseCaseType;", "", "surfaceClass", "Ljava/lang/Class;", "defaultImageFormat", "", "<init>", "(Ljava/lang/String;ILjava/lang/Class;I)V", "getSurfaceClass", "()Ljava/lang/Class;", "getDefaultImageFormat", "()I", "PREVIEW", "IMAGE_CAPTURE", "VIDEO_CAPTURE", "STREAM_SHARING", "UNDEFINED", "getImageFormat", "imageCaptureFormat", "(Ljava/lang/Integer;)I", "toString", "", "Companion", "camera-core_release"})
public final class UseCaseType
extends Enum<UseCaseType> {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Class<?> surfaceClass;
    private final int defaultImageFormat;
    public static final /* enum */ UseCaseType PREVIEW;
    public static final /* enum */ UseCaseType IMAGE_CAPTURE;
    public static final /* enum */ UseCaseType VIDEO_CAPTURE;
    public static final /* enum */ UseCaseType STREAM_SHARING;
    public static final /* enum */ UseCaseType UNDEFINED;
    private static final /* synthetic */ UseCaseType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private UseCaseType(Class<?> surfaceClass, int defaultImageFormat) {
        this.surfaceClass = surfaceClass;
        this.defaultImageFormat = defaultImageFormat;
    }

    @Nullable
    public final Class<?> getSurfaceClass() {
        return this.surfaceClass;
    }

    public final int getDefaultImageFormat() {
        return this.defaultImageFormat;
    }

    public final int getImageFormat(@Nullable Integer imageCaptureFormat) {
        return this == IMAGE_CAPTURE && imageCaptureFormat != null ? imageCaptureFormat : this.defaultImageFormat;
    }

    public static /* synthetic */ int getImageFormat$default(UseCaseType useCaseType, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getImageFormat");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        return useCaseType.getImageFormat(n);
    }

    @NotNull
    public String toString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                string = "Preview";
                break;
            }
            case 2: {
                string = "ImageCapture";
                break;
            }
            case 3: {
                string = "VideoCapture";
                break;
            }
            case 4: {
                string = "StreamSharing";
                break;
            }
            case 5: {
                string = "Undefined";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static UseCaseType[] values() {
        return (UseCaseType[])$VALUES.clone();
    }

    public static UseCaseType valueOf(String value) {
        return Enum.valueOf(UseCaseType.class, value);
    }

    @NotNull
    public static EnumEntries<UseCaseType> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final UseCaseType getFeatureGroupUseCaseType(@NotNull UseCase $this$getFeatureGroupUseCaseType) {
        return Companion.getFeatureGroupUseCaseType($this$getFeatureGroupUseCaseType);
    }

    @JvmStatic
    @NotNull
    public static final UseCaseType getFeatureGroupUseCaseType(@NotNull UseCaseConfig<?> $this$getFeatureGroupUseCaseType) {
        return Companion.getFeatureGroupUseCaseType($this$getFeatureGroupUseCaseType);
    }

    static {
        PREVIEW = new UseCaseType(SurfaceHolder.class, 34);
        IMAGE_CAPTURE = new UseCaseType(null, 256);
        VIDEO_CAPTURE = new UseCaseType(MediaCodec.class, 34);
        STREAM_SHARING = new UseCaseType(SurfaceTexture.class, 34);
        UNDEFINED = new UseCaseType(null, 34);
        $VALUES = useCaseTypeArray = new UseCaseType[]{UseCaseType.PREVIEW, UseCaseType.IMAGE_CAPTURE, UseCaseType.VIDEO_CAPTURE, UseCaseType.STREAM_SHARING, UseCaseType.UNDEFINED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\u0010\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u0007H\u0007J\u0013\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u0014\u0010\u000b\u001a\u00020\f*\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\u0006H\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0006H\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\u0006H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Landroidx/camera/core/featuregroup/impl/UseCaseType$Companion;", "", "<init>", "()V", "getFeatureGroupUseCaseType", "Landroidx/camera/core/featuregroup/impl/UseCaseType;", "Landroidx/camera/core/UseCase;", "Landroidx/camera/core/impl/UseCaseConfig;", "getAppConfiguredGroupableFeatureType", "Landroidx/camera/core/featuregroup/impl/feature/FeatureTypeInternal;", "getAppConfiguredGroupableFeatureType$camera_core_release", "isConfiguredToUseCaseByApp", "", "useCase", "isDynamicRangeConfiguredByApp", "isFpsRangeConfiguredByApp", "isStabilizationModeConfiguredByApp", "isImageFormatConfiguredByApp", "camera-core_release"})
    @SourceDebugExtension(value={"SMAP\nUseCaseType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseCaseType.kt\nandroidx/camera/core/featuregroup/impl/UseCaseType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UseCaseType getFeatureGroupUseCaseType(@NotNull UseCase $this$getFeatureGroupUseCaseType) {
            Intrinsics.checkNotNullParameter((Object)$this$getFeatureGroupUseCaseType, (String)"<this>");
            return $this$getFeatureGroupUseCaseType instanceof Preview ? PREVIEW : ($this$getFeatureGroupUseCaseType instanceof ImageCapture ? IMAGE_CAPTURE : (CameraUseCaseAdapter.isVideoCapture($this$getFeatureGroupUseCaseType) ? VIDEO_CAPTURE : ($this$getFeatureGroupUseCaseType instanceof StreamSharing ? STREAM_SHARING : UNDEFINED)));
        }

        @JvmStatic
        @NotNull
        public final UseCaseType getFeatureGroupUseCaseType(@NotNull UseCaseConfig<?> $this$getFeatureGroupUseCaseType) {
            UseCaseType useCaseType;
            Intrinsics.checkNotNullParameter($this$getFeatureGroupUseCaseType, (String)"<this>");
            switch (WhenMappings.$EnumSwitchMapping$0[$this$getFeatureGroupUseCaseType.getCaptureType().ordinal()]) {
                case 1: {
                    useCaseType = IMAGE_CAPTURE;
                    break;
                }
                case 2: {
                    useCaseType = PREVIEW;
                    break;
                }
                case 3: {
                    useCaseType = VIDEO_CAPTURE;
                    break;
                }
                case 4: {
                    useCaseType = STREAM_SHARING;
                    break;
                }
                default: {
                    useCaseType = UNDEFINED;
                }
            }
            return useCaseType;
        }

        @Nullable
        public final FeatureTypeInternal getAppConfiguredGroupableFeatureType$camera_core_release(@NotNull UseCase $this$getAppConfiguredGroupableFeatureType) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$getAppConfiguredGroupableFeatureType, (String)"<this>");
                Iterable iterable = (Iterable)FeatureTypeInternal.getEntries();
                for (Object t : iterable) {
                    FeatureTypeInternal it = (FeatureTypeInternal)((Object)t);
                    boolean bl = false;
                    if (!Companion.isConfiguredToUseCaseByApp(it, $this$getAppConfiguredGroupableFeatureType)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final boolean isConfiguredToUseCaseByApp(FeatureTypeInternal $this$isConfiguredToUseCaseByApp, UseCase useCase) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$isConfiguredToUseCaseByApp.ordinal()]) {
                case 1: {
                    bl = this.isDynamicRangeConfiguredByApp(useCase);
                    break;
                }
                case 2: {
                    bl = this.isFpsRangeConfiguredByApp(useCase);
                    break;
                }
                case 3: {
                    bl = this.isStabilizationModeConfiguredByApp(useCase);
                    break;
                }
                case 4: {
                    bl = this.isImageFormatConfiguredByApp(useCase);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        private final boolean isDynamicRangeConfiguredByApp(UseCase $this$isDynamicRangeConfiguredByApp) {
            return $this$isDynamicRangeConfiguredByApp.getAppConfig().hasDynamicRange();
        }

        private final boolean isFpsRangeConfiguredByApp(UseCase $this$isFpsRangeConfiguredByApp) {
            return $this$isFpsRangeConfiguredByApp.getAppConfig().hasTargetFrameRate();
        }

        private final boolean isStabilizationModeConfiguredByApp(UseCase $this$isStabilizationModeConfiguredByApp) {
            return $this$isStabilizationModeConfiguredByApp.getAppConfig().containsOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE) || $this$isStabilizationModeConfiguredByApp.getAppConfig().containsOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE);
        }

        private final boolean isImageFormatConfiguredByApp(UseCase $this$isImageFormatConfiguredByApp) {
            return $this$isImageFormatConfiguredByApp.getAppConfig().containsOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[UseCaseConfigFactory.CaptureType.values().length];
                try {
                    nArray[UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UseCaseConfigFactory.CaptureType.PREVIEW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UseCaseConfigFactory.CaptureType.STREAM_SHARING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[FeatureTypeInternal.values().length];
                try {
                    nArray[FeatureTypeInternal.DYNAMIC_RANGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureTypeInternal.FPS_RANGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureTypeInternal.VIDEO_STABILIZATION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FeatureTypeInternal.IMAGE_FORMAT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UseCaseType.values().length];
            try {
                nArray[UseCaseType.PREVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCaseType.IMAGE_CAPTURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCaseType.VIDEO_CAPTURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCaseType.STREAM_SHARING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCaseType.UNDEFINED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

