/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.featuregroup.impl;

import androidx.camera.core.Logger;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.resolver.DefaultFeatureGroupResolver;
import androidx.camera.core.featuregroup.impl.resolver.FeatureGroupResolutionResult;
import androidx.camera.core.featuregroup.impl.resolver.FeatureGroupResolver;
import androidx.camera.core.impl.CameraInfoInternal;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Landroidx/camera/core/featuregroup/impl/ResolvedFeatureGroup;", "", "features", "", "Landroidx/camera/core/featuregroup/GroupableFeature;", "<init>", "(Ljava/util/Set;)V", "getFeatures", "()Ljava/util/Set;", "toString", "", "Companion", "camera-core_release"})
public final class ResolvedFeatureGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<GroupableFeature> features;
    @NotNull
    private static final String TAG = "ResolvedFeatureGroup";

    public ResolvedFeatureGroup(@NotNull Set<? extends GroupableFeature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.features = features;
    }

    @NotNull
    public final Set<GroupableFeature> getFeatures() {
        return this.features;
    }

    @NotNull
    public String toString() {
        return "ResolvedFeatureGroup(features=" + this.features + ')';
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ResolvedFeatureGroup resolveFeatureGroup(@NotNull SessionConfig $this$resolveFeatureGroup, @NotNull CameraInfoInternal cameraInfoInternal, @NotNull FeatureGroupResolver resolver) {
        return Companion.resolveFeatureGroup($this$resolveFeatureGroup, cameraInfoInternal, resolver);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ResolvedFeatureGroup resolveFeatureGroup(@NotNull SessionConfig $this$resolveFeatureGroup, @NotNull CameraInfoInternal cameraInfoInternal) {
        return Companion.resolveFeatureGroup($this$resolveFeatureGroup, cameraInfoInternal);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/camera/core/featuregroup/impl/ResolvedFeatureGroup$Companion;", "", "<init>", "()V", "TAG", "", "resolveFeatureGroup", "Landroidx/camera/core/featuregroup/impl/ResolvedFeatureGroup;", "Landroidx/camera/core/SessionConfig;", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "resolver", "Landroidx/camera/core/featuregroup/impl/resolver/FeatureGroupResolver;", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ResolvedFeatureGroup resolveFeatureGroup(@NotNull SessionConfig $this$resolveFeatureGroup, @NotNull CameraInfoInternal cameraInfoInternal, @NotNull FeatureGroupResolver resolver) {
            Intrinsics.checkNotNullParameter((Object)$this$resolveFeatureGroup, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Logger.d(ResolvedFeatureGroup.TAG, "resolveFeatureGroup: sessionConfig = " + $this$resolveFeatureGroup + ", lensFacing = " + cameraInfoInternal.getLensFacing());
            if ($this$resolveFeatureGroup.getRequiredFeatureGroup().isEmpty() && $this$resolveFeatureGroup.getPreferredFeatureGroup().isEmpty()) {
                return null;
            }
            FeatureGroupResolutionResult result = resolver.resolveFeatureGroup($this$resolveFeatureGroup);
            FeatureGroupResolutionResult featureGroupResolutionResult = result;
            if (featureGroupResolutionResult instanceof FeatureGroupResolutionResult.Supported) {
                ResolvedFeatureGroup resolvedFeatureGroup = ((FeatureGroupResolutionResult.Supported)result).getResolvedFeatureGroup();
                Logger.d(ResolvedFeatureGroup.TAG, "resolvedFeatureGroup = " + resolvedFeatureGroup);
                return resolvedFeatureGroup;
            }
            if (featureGroupResolutionResult instanceof FeatureGroupResolutionResult.Unsupported) {
                throw new IllegalArgumentException("Feature group is not supported");
            }
            if (featureGroupResolutionResult instanceof FeatureGroupResolutionResult.UnsupportedUseCase) {
                throw new IllegalArgumentException(((FeatureGroupResolutionResult.UnsupportedUseCase)result).getUnsupportedUseCase() + " is not supported");
            }
            if (featureGroupResolutionResult instanceof FeatureGroupResolutionResult.UseCaseMissing) {
                throw new IllegalArgumentException(((FeatureGroupResolutionResult.UseCaseMissing)result).getRequiredUseCases() + " must be added for " + ((FeatureGroupResolutionResult.UseCaseMissing)result).getFeatureRequiring());
            }
            throw new NoWhenBranchMatchedException();
        }

        public static /* synthetic */ ResolvedFeatureGroup resolveFeatureGroup$default(Companion companion, SessionConfig sessionConfig, CameraInfoInternal cameraInfoInternal, FeatureGroupResolver featureGroupResolver, int n, Object object) {
            if ((n & 2) != 0) {
                featureGroupResolver = new DefaultFeatureGroupResolver(cameraInfoInternal);
            }
            return companion.resolveFeatureGroup(sessionConfig, cameraInfoInternal, featureGroupResolver);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ResolvedFeatureGroup resolveFeatureGroup(@NotNull SessionConfig $this$resolveFeatureGroup, @NotNull CameraInfoInternal cameraInfoInternal) {
            Intrinsics.checkNotNullParameter((Object)$this$resolveFeatureGroup, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
            return androidx.camera.core.featuregroup.impl.ResolvedFeatureGroup$Companion.resolveFeatureGroup$default(this, $this$resolveFeatureGroup, cameraInfoInternal, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

