/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.featuregroup;

import androidx.annotation.RestrictTo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.featuregroup.impl.feature.DynamicRangeFeature;
import androidx.camera.core.featuregroup.impl.feature.FeatureTypeInternal;
import androidx.camera.core.featuregroup.impl.feature.FpsRangeFeature;
import androidx.camera.core.featuregroup.impl.feature.ImageFormatFeature;
import androidx.camera.core.featuregroup.impl.feature.VideoStabilizationFeature;
import androidx.camera.core.impl.CameraInfoInternal;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\t\b\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\f\u0010\u0014\u001a\u00020\t*\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Landroidx/camera/core/featuregroup/GroupableFeature;", "", "<init>", "()V", "featureTypeInternal", "Landroidx/camera/core/featuregroup/impl/feature/FeatureTypeInternal;", "getFeatureTypeInternal$camera_core_release", "()Landroidx/camera/core/featuregroup/impl/feature/FeatureTypeInternal;", "featureType", "", "getFeatureType", "()I", "featureType$delegate", "Lkotlin/Lazy;", "isSupportedIndividually", "", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "sessionConfig", "Landroidx/camera/core/SessionConfig;", "toFeatureType", "FeatureType", "Companion", "camera-core_release"})
@ExperimentalSessionConfig
public abstract class GroupableFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy featureType$delegate = LazyKt.lazy(() -> GroupableFeature.featureType_delegate$lambda$0(this));
    @JvmField
    @NotNull
    public static final GroupableFeature HDR_HLG10;
    @JvmField
    @NotNull
    public static final GroupableFeature FPS_60;
    @JvmField
    @NotNull
    public static final GroupableFeature PREVIEW_STABILIZATION;
    @JvmField
    @NotNull
    public static final GroupableFeature IMAGE_ULTRA_HDR;
    public static final int FEATURE_TYPE_DYNAMIC_RANGE = 0;
    public static final int FEATURE_TYPE_FPS_RANGE = 1;
    public static final int FEATURE_TYPE_VIDEO_STABILIZATION = 2;
    public static final int FEATURE_TYPE_IMAGE_FORMAT = 3;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public GroupableFeature() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public abstract FeatureTypeInternal getFeatureTypeInternal$camera_core_release();

    public final int getFeatureType() {
        Lazy lazy = this.featureType$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isSupportedIndividually(@NotNull CameraInfoInternal cameraInfoInternal, @NotNull SessionConfig sessionConfig) {
        Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return true;
    }

    private final int toFeatureType(FeatureTypeInternal $this$toFeatureType) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toFeatureType.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int featureType_delegate$lambda$0(GroupableFeature this$0) {
        return this$0.toFeatureType(this$0.getFeatureTypeInternal$camera_core_release());
    }

    static {
        DynamicRange dynamicRange = DynamicRange.HLG_10_BIT;
        Intrinsics.checkNotNullExpressionValue((Object)dynamicRange, (String)"HLG_10_BIT");
        HDR_HLG10 = new DynamicRangeFeature(dynamicRange);
        FPS_60 = new FpsRangeFeature(60, 60);
        PREVIEW_STABILIZATION = new VideoStabilizationFeature(VideoStabilizationFeature.StabilizationMode.PREVIEW);
        IMAGE_ULTRA_HDR = new ImageFormatFeature(1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/camera/core/featuregroup/GroupableFeature$Companion;", "", "<init>", "()V", "HDR_HLG10", "Landroidx/camera/core/featuregroup/GroupableFeature;", "FPS_60", "PREVIEW_STABILIZATION", "IMAGE_ULTRA_HDR", "FEATURE_TYPE_DYNAMIC_RANGE", "", "FEATURE_TYPE_FPS_RANGE", "FEATURE_TYPE_VIDEO_STABILIZATION", "FEATURE_TYPE_IMAGE_FORMAT", "camera-core_release"})
    @ExperimentalSessionConfig
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.TYPE})
    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/camera/core/featuregroup/GroupableFeature$FeatureType;", "", "camera-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FeatureType {
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureTypeInternal.values().length];
            try {
                nArray[FeatureTypeInternal.DYNAMIC_RANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.FPS_RANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.VIDEO_STABILIZATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.IMAGE_FORMAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

