/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Rational;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;

public final class ViewPort {
    public static final int FILL_START = 0;
    public static final int FILL_CENTER = 1;
    public static final int FILL_END = 2;
    public static final int FIT = 3;
    private int mScaleType;
    private @NonNull Rational mAspectRatio;
    private int mRotation;
    private int mLayoutDirection;

    ViewPort(int scaleType, @NonNull Rational aspectRatio, int rotation, int layoutDirection) {
        this.mScaleType = scaleType;
        this.mAspectRatio = aspectRatio;
        this.mRotation = rotation;
        this.mLayoutDirection = layoutDirection;
    }

    public @NonNull Rational getAspectRatio() {
        return this.mAspectRatio;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public static final class Builder {
        private static final int DEFAULT_LAYOUT_DIRECTION = 0;
        private static final int DEFAULT_SCALE_TYPE = 1;
        private int mScaleType = 1;
        private final Rational mAspectRatio;
        private final int mRotation;
        private int mLayoutDirection = 0;

        public Builder(@NonNull Rational aspectRatio, int rotation) {
            this.mAspectRatio = aspectRatio;
            this.mRotation = rotation;
        }

        public @NonNull Builder setScaleType(int scaleType) {
            this.mScaleType = scaleType;
            return this;
        }

        public @NonNull Builder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        public @NonNull ViewPort build() {
            Preconditions.checkNotNull((Object)this.mAspectRatio, (Object)"The crop aspect ratio must be set.");
            return new ViewPort(this.mScaleType, this.mAspectRatio, this.mRotation, this.mLayoutDirection);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ScaleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LayoutDirection {
    }
}

