/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.camera.core.CameraEffect;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.processing.TargetUtils;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class UseCaseGroup {
    private final @Nullable ViewPort mViewPort;
    private final @NonNull List<UseCase> mUseCases;
    private final @NonNull List<CameraEffect> mEffects;

    UseCaseGroup(@Nullable ViewPort viewPort, @NonNull List<UseCase> useCases, @NonNull List<CameraEffect> effects) {
        this.mViewPort = viewPort;
        this.mUseCases = useCases;
        this.mEffects = effects;
    }

    public @Nullable ViewPort getViewPort() {
        return this.mViewPort;
    }

    public @NonNull List<UseCase> getUseCases() {
        return this.mUseCases;
    }

    public @NonNull List<CameraEffect> getEffects() {
        return this.mEffects;
    }

    public static final class Builder {
        private static final List<Integer> SUPPORTED_TARGETS = Arrays.asList(1, 2, 4, 3, 7);
        private ViewPort mViewPort;
        private final List<UseCase> mUseCases = new ArrayList<UseCase>();
        private final List<CameraEffect> mEffects = new ArrayList<CameraEffect>();

        public @NonNull Builder setViewPort(@NonNull ViewPort viewPort) {
            this.mViewPort = viewPort;
            return this;
        }

        public @NonNull Builder addEffect(@NonNull CameraEffect cameraEffect) {
            this.mEffects.add(cameraEffect);
            return this;
        }

        private void checkEffectTargets() {
            int existingTargets = 0;
            for (CameraEffect effect : this.mEffects) {
                int targets = effect.getTargets();
                TargetUtils.checkSupportedTargets(SUPPORTED_TARGETS, targets);
                int overlappingTargets = existingTargets & targets;
                if (overlappingTargets > 0) {
                    throw new IllegalArgumentException(String.format(Locale.US, "More than one effects has targets %s.", TargetUtils.getHumanReadableName(overlappingTargets)));
                }
                existingTargets |= targets;
            }
        }

        public @NonNull Builder addUseCase(@NonNull UseCase useCase) {
            this.mUseCases.add(useCase);
            return this;
        }

        public @NonNull UseCaseGroup build() {
            Preconditions.checkArgument((!this.mUseCases.isEmpty() ? 1 : 0) != 0, (Object)"UseCase must not be empty.");
            this.checkEffectTargets();
            return new UseCaseGroup(this.mViewPort, this.mUseCases, this.mEffects);
        }
    }
}

