/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AutoValue_SurfaceRequest_Result;
import androidx.camera.core.AutoValue_SurfaceRequest_TransformationInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SurfaceRequest {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Range<Integer> FRAME_RATE_RANGE_UNSPECIFIED = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
    private final Object mLock = new Object();
    private final Size mResolution;
    private final @NonNull DynamicRange mDynamicRange;
    private final Range<Integer> mExpectedFrameRate;
    private final CameraInternal mCamera;
    private final boolean mIsPrimary;
    private final int mSessionType;
    final ListenableFuture<Surface> mSurfaceFuture;
    private final CallbackToFutureAdapter.Completer<Surface> mSurfaceCompleter;
    private final ListenableFuture<Void> mSessionStatusFuture;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CallbackToFutureAdapter.Completer<Void> mSurfaceRecreationCompleter;
    private final CallbackToFutureAdapter.Completer<Void> mRequestCancellationCompleter;
    private final DeferrableSurface mInternalDeferrableSurface;
    @GuardedBy(value="mLock")
    private @Nullable TransformationInfo mTransformationInfo;
    @GuardedBy(value="mLock")
    private @Nullable TransformationInfoListener mTransformationInfoListener;
    @GuardedBy(value="mLock")
    private @Nullable Executor mTransformationInfoExecutor;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, @NonNull Runnable onInvalidated) {
        this(resolution, camera, DynamicRange.SDR, FRAME_RATE_RANGE_UNSPECIFIED, onInvalidated);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRate, @NonNull Runnable onInvalidated) {
        this(resolution, camera, true, dynamicRange, 0, expectedFrameRate, onInvalidated);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceRequest(@NonNull Size resolution, @NonNull CameraInternal camera, boolean isPrimary, @NonNull DynamicRange dynamicRange, int sessionType, @NonNull Range<Integer> expectedFrameRate, @NonNull Runnable onInvalidated) {
        CallbackToFutureAdapter.Completer requestCancellationCompleter;
        this.mResolution = resolution;
        this.mCamera = camera;
        this.mIsPrimary = isPrimary;
        Preconditions.checkArgument((boolean)dynamicRange.isFullySpecified(), (Object)"SurfaceRequest's DynamicRange must always be fully specified.");
        this.mDynamicRange = dynamicRange;
        this.mSessionType = sessionType;
        this.mExpectedFrameRate = expectedFrameRate;
        final String surfaceRequestString = "SurfaceRequest[size: " + resolution + ", id: " + this.hashCode() + "]";
        AtomicReference<Object> cancellationCompleterRef = new AtomicReference<Object>(null);
        final ListenableFuture requestCancellationFuture = CallbackToFutureAdapter.getFuture(completer -> {
            cancellationCompleterRef.set(completer);
            return surfaceRequestString + "-cancellation";
        });
        this.mRequestCancellationCompleter = requestCancellationCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)cancellationCompleterRef.get());
        AtomicReference<Object> sessionStatusCompleterRef = new AtomicReference<Object>(null);
        this.mSessionStatusFuture = CallbackToFutureAdapter.getFuture(completer -> {
            sessionStatusCompleterRef.set(completer);
            return surfaceRequestString + "-status";
        });
        Futures.addCallback(this.mSessionStatusFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                Preconditions.checkState((boolean)requestCancellationCompleter.set(null));
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (t instanceof RequestCancelledException) {
                    Preconditions.checkState((boolean)requestCancellationFuture.cancel(false));
                } else {
                    Preconditions.checkState((boolean)requestCancellationCompleter.set(null));
                }
            }
        }, CameraXExecutors.directExecutor());
        final CallbackToFutureAdapter.Completer sessionStatusCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)sessionStatusCompleterRef.get());
        AtomicReference<Object> surfaceCompleterRef = new AtomicReference<Object>(null);
        this.mSurfaceFuture = CallbackToFutureAdapter.getFuture(completer -> {
            surfaceCompleterRef.set(completer);
            return surfaceRequestString + "-Surface";
        });
        this.mSurfaceCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)surfaceCompleterRef.get());
        this.mInternalDeferrableSurface = new DeferrableSurface(resolution, 34){

            @Override
            protected @NonNull ListenableFuture<Surface> provideSurface() {
                return SurfaceRequest.this.mSurfaceFuture;
            }
        };
        final ListenableFuture<Void> terminationFuture = this.mInternalDeferrableSurface.getTerminationFuture();
        Futures.addCallback(this.mSurfaceFuture, new FutureCallback<Surface>(){

            @Override
            public void onSuccess(@Nullable Surface result) {
                Futures.propagate(terminationFuture, sessionStatusCompleter);
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (t instanceof CancellationException) {
                    Preconditions.checkState((boolean)sessionStatusCompleter.setException((Throwable)new RequestCancelledException(surfaceRequestString + " cancelled.", t)));
                } else {
                    sessionStatusCompleter.set(null);
                }
            }
        }, CameraXExecutors.directExecutor());
        terminationFuture.addListener(() -> this.mSurfaceFuture.cancel(true), CameraXExecutors.directExecutor());
        this.mSurfaceRecreationCompleter = this.initialSurfaceRecreationCompleter(CameraXExecutors.directExecutor(), onInvalidated);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull DeferrableSurface getDeferrableSurface() {
        return this.mInternalDeferrableSurface;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isServiced() {
        return this.mSurfaceFuture.isDone();
    }

    public @NonNull Size getResolution() {
        return this.mResolution;
    }

    public @NonNull DynamicRange getDynamicRange() {
        return this.mDynamicRange;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSessionType() {
        return this.mSessionType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull Range<Integer> getExpectedFrameRate() {
        return this.mExpectedFrameRate;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull CameraInternal getCamera() {
        return this.mCamera;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public void provideSurface(final @NonNull Surface surface, @NonNull Executor executor, final @NonNull Consumer<Result> resultListener) {
        if (!surface.isValid()) {
            executor.execute(() -> resultListener.accept((Object)Result.of(2, surface)));
            return;
        }
        if (this.mSurfaceCompleter.set((Object)surface) || this.mSurfaceFuture.isCancelled()) {
            Futures.addCallback(this.mSessionStatusFuture, new FutureCallback<Void>(){

                @Override
                public void onSuccess(@Nullable Void result) {
                    resultListener.accept((Object)Result.of(0, surface));
                }

                @Override
                public void onFailure(@NonNull Throwable t) {
                    Preconditions.checkState((boolean)(t instanceof RequestCancelledException), (String)("Camera surface session should only fail with request cancellation. Instead failed due to:\n" + t));
                    resultListener.accept((Object)Result.of(1, surface));
                }
            }, executor);
        } else {
            Preconditions.checkState((boolean)this.mSurfaceFuture.isDone());
            try {
                this.mSurfaceFuture.get();
                executor.execute(() -> resultListener.accept((Object)Result.of(3, surface)));
            }
            catch (InterruptedException | ExecutionException e) {
                executor.execute(() -> resultListener.accept((Object)Result.of(4, surface)));
            }
        }
    }

    public boolean willNotProvideSurface() {
        return this.mSurfaceCompleter.setException((Throwable)new DeferrableSurface.SurfaceUnavailableException("Surface request will not complete."));
    }

    private CallbackToFutureAdapter.Completer<Void> initialSurfaceRecreationCompleter(@NonNull Executor executor, final @NonNull Runnable runnable) {
        AtomicReference<Object> completerRef = new AtomicReference<Object>(null);
        ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
            completerRef.set(completer);
            return "SurfaceRequest-surface-recreation(" + this.hashCode() + ")";
        });
        Futures.addCallback(future, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                runnable.run();
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
            }
        }, executor);
        return (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)completerRef.get());
    }

    public boolean invalidate() {
        this.willNotProvideSurface();
        return this.mSurfaceRecreationCompleter.set(null);
    }

    @SuppressLint(value={"PairedRegistration"})
    public void addRequestCancellationListener(@NonNull Executor executor, @NonNull Runnable listener) {
        this.mRequestCancellationCompleter.addCancellationListener(listener, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateTransformationInfo(@NonNull TransformationInfo transformationInfo) {
        Executor executor;
        TransformationInfoListener listener;
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfo = transformationInfo;
            listener = this.mTransformationInfoListener;
            executor = this.mTransformationInfoExecutor;
        }
        if (listener != null && executor != null) {
            executor.execute(() -> listener.onTransformationInfoUpdate(transformationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformationInfoListener(@NonNull Executor executor, @NonNull TransformationInfoListener listener) {
        TransformationInfo transformationInfo;
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfoListener = listener;
            this.mTransformationInfoExecutor = executor;
            transformationInfo = this.mTransformationInfo;
        }
        if (transformationInfo != null) {
            executor.execute(() -> listener.onTransformationInfoUpdate(transformationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransformationInfoListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTransformationInfoListener = null;
            this.mTransformationInfoExecutor = null;
        }
    }

    @AutoValue
    public static abstract class TransformationInfo {
        public abstract @NonNull Rect getCropRect();

        public abstract int getRotationDegrees();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public abstract int getTargetRotation();

        public abstract boolean hasCameraTransform();

        public abstract @NonNull Matrix getSensorToBufferTransform();

        public abstract boolean isMirroring();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @NonNull TransformationInfo of(@NonNull Rect cropRect, int rotationDegrees, int targetRotation, boolean hasCameraTransform, @NonNull Matrix sensorToBufferTransform, boolean mirroring) {
            return new AutoValue_SurfaceRequest_TransformationInfo(cropRect, rotationDegrees, targetRotation, hasCameraTransform, sensorToBufferTransform, mirroring);
        }

        TransformationInfo() {
        }
    }

    public static interface TransformationInfoListener {
        public void onTransformationInfoUpdate(@NonNull TransformationInfo var1);
    }

    @AutoValue
    public static abstract class Result {
        public static final int RESULT_SURFACE_USED_SUCCESSFULLY = 0;
        public static final int RESULT_REQUEST_CANCELLED = 1;
        public static final int RESULT_INVALID_SURFACE = 2;
        public static final int RESULT_SURFACE_ALREADY_PROVIDED = 3;
        public static final int RESULT_WILL_NOT_PROVIDE_SURFACE = 4;

        static @NonNull Result of(int code, @NonNull Surface surface) {
            return new AutoValue_SurfaceRequest_Result(code, surface);
        }

        public abstract int getResultCode();

        public abstract @NonNull Surface getSurface();

        Result() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ResultCode {
        }
    }

    private static final class RequestCancelledException
    extends RuntimeException {
        RequestCancelledException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }
    }
}

