/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.RestrictTo;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.UseCase;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SurfaceOrientedMeteringPointFactory
extends MeteringPointFactory {
    private final float mWidth;
    private final float mHeight;

    public SurfaceOrientedMeteringPointFactory(float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public SurfaceOrientedMeteringPointFactory(float width, float height, @NonNull UseCase useCaseForAspectRatio) {
        super(SurfaceOrientedMeteringPointFactory.getUseCaseAspectRatio(useCaseForAspectRatio));
        this.mWidth = width;
        this.mHeight = height;
    }

    private static @Nullable Rational getUseCaseAspectRatio(@Nullable UseCase useCase) {
        if (useCase == null) {
            return null;
        }
        Size resolution = useCase.getAttachedSurfaceResolution();
        if (resolution == null) {
            throw new IllegalStateException("UseCase " + useCase + " is not bound.");
        }
        return new Rational(resolution.getWidth(), resolution.getHeight());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull PointF convertPoint(float x, float y) {
        PointF pt = new PointF(x / this.mWidth, y / this.mHeight);
        return pt;
    }
}

