/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Range;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.UseCaseType;
import androidx.camera.core.featuregroup.impl.feature.FeatureTypeInternal;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.core.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u00017Bc\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0012\"\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0013J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\b\u00100\u001a\u00020.H\u0002J\f\u00101\u001a\u00020.*\u00020\u0004H\u0002J\f\u00102\u001a\u000203*\u00020\u0004H\u0002J&\u00104\u001a\u00020.2\b\b\u0002\u00105\u001a\u00020)2\u0012\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0%H\u0007R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0016\u0010\u001e\u001a\u00020\u001f8WX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010 R\u0016\u0010!\u001a\u00020\u000b8WX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R6\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0%2\u0012\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001e\u0010*\u001a\u00020)2\u0006\u0010$\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00068"}, d2={"Landroidx/camera/core/SessionConfig;", "", "useCases", "", "Landroidx/camera/core/UseCase;", "viewPort", "Landroidx/camera/core/ViewPort;", "effects", "Landroidx/camera/core/CameraEffect;", "frameRateRange", "Landroid/util/Range;", "", "requiredFeatureGroup", "", "Landroidx/camera/core/featuregroup/GroupableFeature;", "preferredFeatureGroup", "<init>", "(Ljava/util/List;Landroidx/camera/core/ViewPort;Ljava/util/List;Landroid/util/Range;Ljava/util/Set;Ljava/util/List;)V", "", "([Landroidx/camera/core/UseCase;)V", "getViewPort", "()Landroidx/camera/core/ViewPort;", "getEffects", "()Ljava/util/List;", "getFrameRateRange", "()Landroid/util/Range;", "getRequiredFeatureGroup", "()Ljava/util/Set;", "getPreferredFeatureGroup", "getUseCases", "isLegacy", "", "()Z", "sessionType", "getSessionType", "()I", "value", "Landroidx/core/util/Consumer;", "featureSelectionListener", "getFeatureSelectionListener", "()Landroidx/core/util/Consumer;", "Ljava/util/concurrent/Executor;", "featureSelectionListenerExecutor", "getFeatureSelectionListenerExecutor", "()Ljava/util/concurrent/Executor;", "validateFrameRate", "", "validateFeatureGroups", "validateRequiredFeatures", "validateDefaultGroupableFeatureValues", "getUseCaseName", "", "setFeatureSelectionListener", "executor", "listener", "Builder", "camera-core_release"})
@ExperimentalSessionConfig
@SourceDebugExtension(value={"SMAP\nSessionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionConfig.kt\nandroidx/camera/core/SessionConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n1863#2,2:397\n1557#2:400\n1628#2,3:401\n1863#2:404\n774#2:405\n865#2,2:406\n1864#2:408\n1#3:399\n*S KotlinDebug\n*F\n+ 1 SessionConfig.kt\nandroidx/camera/core/SessionConfig\n*L\n158#1:397,2\n176#1:400\n176#1:401,3\n177#1:404\n179#1:405\n179#1:406,2\n177#1:408\n*E\n"})
public class SessionConfig {
    @Nullable
    private final ViewPort viewPort;
    @NotNull
    private final List<CameraEffect> effects;
    @NotNull
    private final Range<Integer> frameRateRange;
    @NotNull
    private final Set<GroupableFeature> requiredFeatureGroup;
    @NotNull
    private final List<GroupableFeature> preferredFeatureGroup;
    @NotNull
    private final List<UseCase> useCases;
    private final boolean isLegacy;
    private final int sessionType;
    @NotNull
    private Consumer<Set<GroupableFeature>> featureSelectionListener;
    @NotNull
    private Executor featureSelectionListenerExecutor;

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases, @Nullable ViewPort viewPort, @NotNull List<? extends CameraEffect> effects, @NotNull Range<Integer> frameRateRange, @NotNull Set<? extends GroupableFeature> requiredFeatureGroup, @NotNull List<? extends GroupableFeature> preferredFeatureGroup) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
        Intrinsics.checkNotNullParameter(requiredFeatureGroup, (String)"requiredFeatureGroup");
        Intrinsics.checkNotNullParameter(preferredFeatureGroup, (String)"preferredFeatureGroup");
        this.viewPort = viewPort;
        this.effects = effects;
        this.frameRateRange = frameRateRange;
        this.requiredFeatureGroup = requiredFeatureGroup;
        this.preferredFeatureGroup = preferredFeatureGroup;
        this.useCases = CollectionsKt.distinct((Iterable)useCases);
        this.featureSelectionListener = SessionConfig::featureSelectionListener$lambda$0;
        ScheduledExecutorService scheduledExecutorService = CameraXExecutors.mainThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"mainThreadExecutor(...)");
        this.featureSelectionListenerExecutor = scheduledExecutorService;
        this.validateFrameRate();
        this.validateFeatureGroups();
    }

    public /* synthetic */ SessionConfig(List list, ViewPort viewPort, List list2, Range range, Set set, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            viewPort = null;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            range = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(list, viewPort, list2, range, set, list3);
    }

    @Nullable
    public final ViewPort getViewPort() {
        return this.viewPort;
    }

    @NotNull
    public final List<CameraEffect> getEffects() {
        return this.effects;
    }

    @NotNull
    public final Range<Integer> getFrameRateRange() {
        return this.frameRateRange;
    }

    @NotNull
    public final Set<GroupableFeature> getRequiredFeatureGroup() {
        return this.requiredFeatureGroup;
    }

    @NotNull
    public final List<GroupableFeature> getPreferredFeatureGroup() {
        return this.preferredFeatureGroup;
    }

    @NotNull
    public final List<UseCase> getUseCases() {
        return this.useCases;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isLegacy() {
        return this.isLegacy;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSessionType() {
        return this.sessionType;
    }

    @NotNull
    public final Consumer<Set<GroupableFeature>> getFeatureSelectionListener() {
        return this.featureSelectionListener;
    }

    @NotNull
    public final Executor getFeatureSelectionListenerExecutor() {
        return this.featureSelectionListenerExecutor;
    }

    public SessionConfig(UseCase ... useCases) {
        Intrinsics.checkNotNullParameter((Object)useCases, (String)"useCases");
        this(ArraysKt.toList((Object[])useCases), null, null, null, null, null, 62, null);
    }

    private final void validateFrameRate() {
        if (Intrinsics.areEqual(this.frameRateRange, StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            return;
        }
        for (UseCase useCase : this.useCases) {
            if (!useCase.getAppConfig().hasTargetFrameRate()) continue;
            boolean bl = false;
            String string = "Can't set target frame rate on a UseCase (by Preview.Builder.setTargetFrameRate() or VideoCapture.Builder.setTargetFrameRate()) if the frame rate range has already been set in the SessionConfig.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateFeatureGroups() {
        if (this.requiredFeatureGroup.isEmpty() && this.preferredFeatureGroup.isEmpty()) {
            return;
        }
        this.validateRequiredFeatures();
        if (!(CollectionsKt.distinct((Iterable)this.preferredFeatureGroup).size() == this.preferredFeatureGroup.size())) {
            boolean $i$a$-require-SessionConfig$validateFeatureGroups$32 = false;
            String $i$a$-require-SessionConfig$validateFeatureGroups$32 = "Duplicate values in preferredFeatures(" + this.preferredFeatureGroup + ')';
            throw new IllegalArgumentException($i$a$-require-SessionConfig$validateFeatureGroups$32.toString());
        }
        Set duplicateFeatures = CollectionsKt.intersect((Iterable)this.requiredFeatureGroup, (Iterable)this.preferredFeatureGroup);
        if (!duplicateFeatures.isEmpty()) {
            boolean $i$a$-require-SessionConfig$validateFeatureGroups$52 = false;
            String $i$a$-require-SessionConfig$validateFeatureGroups$52 = "requiredFeatures and preferredFeatures have duplicate values: " + duplicateFeatures;
            throw new IllegalArgumentException($i$a$-require-SessionConfig$validateFeatureGroups$52.toString());
        }
        Iterable $this$forEach$iv = this.useCases;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UseCase useCase = (UseCase)element$iv;
            boolean bl = false;
            if (!(UseCaseType.Companion.getFeatureGroupUseCaseType(useCase) != UseCaseType.UNDEFINED)) {
                boolean bl2 = false;
                String string = useCase + " is not supported with feature group";
                throw new IllegalArgumentException(string.toString());
            }
            this.validateDefaultGroupableFeatureValues(useCase);
        }
        if (!this.effects.isEmpty()) {
            boolean bl = false;
            String string = "Effects aren't supported with feature group yet";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateRequiredFeatures() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.requiredFeatureGroup;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GroupableFeature groupableFeature = (GroupableFeature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getFeatureTypeInternal$camera_core_release());
        }
        List requiredFeatureTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = requiredFeatureTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            FeatureTypeInternal featureType = (FeatureTypeInternal)((Object)element$iv);
            boolean bl = false;
            Iterable $this$filter$iv = this.requiredFeatureGroup;
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GroupableFeature it = (GroupableFeature)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getFeatureTypeInternal$camera_core_release() == featureType)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List distinctFeaturesPerType = (List)destination$iv$iv2;
            if (distinctFeaturesPerType.size() <= 1) continue;
            boolean bl4 = false;
            String string = "requiredFeatures has conflicting feature values: " + distinctFeaturesPerType;
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void validateDefaultGroupableFeatureValues(UseCase $this$validateDefaultGroupableFeatureValues) {
        String useCaseName = this.getUseCaseName($this$validateDefaultGroupableFeatureValues);
        FeatureTypeInternal conflictingFeatureType = UseCaseType.Companion.getAppConfiguredGroupableFeatureType$camera_core_release($this$validateDefaultGroupableFeatureValues);
        if (!(conflictingFeatureType == null)) {
            String string;
            String string2;
            String string3;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("A ");
            FeatureTypeInternal featureTypeInternal = conflictingFeatureType;
            Intrinsics.checkNotNull((Object)((Object)featureTypeInternal));
            StringBuilder stringBuilder2 = stringBuilder.append(featureTypeInternal.name()).append(" value is set to ").append(useCaseName).append(" despite using feature groups. Do not use APIs like ").append(useCaseName).append(".Builder.");
            switch (WhenMappings.$EnumSwitchMapping$0[conflictingFeatureType.ordinal()]) {
                case 1: {
                    string3 = "setDynamicRange";
                    break;
                }
                case 2: {
                    string3 = "setTargetFrameRateRange";
                    break;
                }
                case 3: {
                    if (CameraUseCaseAdapter.isVideoCapture($this$validateDefaultGroupableFeatureValues)) {
                        string3 = "setVideoStabilizationEnabled";
                        break;
                    }
                    string3 = "setPreviewStabilizationEnabled";
                    break;
                }
                case 4: {
                    string3 = "setOutputFormat";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" while using feature groups. If ");
            switch (WhenMappings.$EnumSwitchMapping$0[conflictingFeatureType.ordinal()]) {
                case 1: {
                    string2 = "HDR";
                    break;
                }
                case 2: {
                    string2 = "60 FPS";
                    break;
                }
                case 3: {
                    string2 = "stabilization";
                    break;
                }
                case 4: {
                    string2 = "JPEG_R output format";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder stringBuilder4 = stringBuilder3.append(string2).append(" is required, instead set ");
            switch (WhenMappings.$EnumSwitchMapping$0[conflictingFeatureType.ordinal()]) {
                case 1: {
                    string = "GroupableFeature.HDR_HLG10";
                    break;
                }
                case 2: {
                    string = "GroupableFeature.FPS_60";
                    break;
                }
                case 3: {
                    string = "GroupableFeature.PREVIEW_STABILIZATION";
                    break;
                }
                case 4: {
                    string = "GroupableFeature.IMAGE_ULTRA_HDR";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string4 = stringBuilder4.append(string).append(" as either a required or preferred feature.").toString();
            throw new IllegalArgumentException(string4.toString());
        }
    }

    private final String getUseCaseName(UseCase $this$getUseCaseName) {
        return $this$getUseCaseName instanceof Preview ? "Preview" : ($this$getUseCaseName instanceof ImageCapture ? "ImageCapture" : ($this$getUseCaseName instanceof ImageAnalysis ? "ImageAnalysis" : (CameraUseCaseAdapter.isVideoCapture($this$getUseCaseName) ? "VideoCapture" : "UseCase")));
    }

    @JvmOverloads
    public final void setFeatureSelectionListener(@NotNull Executor executor, @NotNull Consumer<Set<GroupableFeature>> listener) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.featureSelectionListener = listener;
        this.featureSelectionListenerExecutor = executor;
    }

    public static /* synthetic */ void setFeatureSelectionListener$default(SessionConfig sessionConfig, Executor executor, Consumer consumer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setFeatureSelectionListener");
        }
        if ((n & 1) != 0) {
            executor = CameraXExecutors.mainThreadExecutor();
        }
        sessionConfig.setFeatureSelectionListener(executor, (Consumer<Set<GroupableFeature>>)consumer);
    }

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases, @Nullable ViewPort viewPort, @NotNull List<? extends CameraEffect> effects, @NotNull Range<Integer> frameRateRange, @NotNull Set<? extends GroupableFeature> requiredFeatureGroup) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
        Intrinsics.checkNotNullParameter(requiredFeatureGroup, (String)"requiredFeatureGroup");
        this(useCases, viewPort, effects, frameRateRange, requiredFeatureGroup, null, 32, null);
    }

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases, @Nullable ViewPort viewPort, @NotNull List<? extends CameraEffect> effects, @NotNull Range<Integer> frameRateRange) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
        this(useCases, viewPort, effects, frameRateRange, null, null, 48, null);
    }

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases, @Nullable ViewPort viewPort, @NotNull List<? extends CameraEffect> effects) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        this(useCases, viewPort, effects, null, null, null, 56, null);
    }

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases, @Nullable ViewPort viewPort) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        this(useCases, viewPort, null, null, null, null, 60, null);
    }

    @JvmOverloads
    public SessionConfig(@NotNull List<? extends UseCase> useCases) {
        Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
        this(useCases, null, null, null, null, null, 62, null);
    }

    @JvmOverloads
    public final void setFeatureSelectionListener(@NotNull Consumer<Set<GroupableFeature>> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        SessionConfig.setFeatureSelectionListener$default(this, null, listener, 1, null);
    }

    private static final void featureSelectionListener$lambda$0(Set it) {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ\u0014\u0010\u0017\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001f\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0007\"\u00020\u0012\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0007\"\u00020\u0012\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/camera/core/SessionConfig$Builder;", "", "useCases", "", "Landroidx/camera/core/UseCase;", "<init>", "(Ljava/util/List;)V", "", "([Landroidx/camera/core/UseCase;)V", "viewPort", "Landroidx/camera/core/ViewPort;", "effects", "", "Landroidx/camera/core/CameraEffect;", "frameRateRange", "Landroid/util/Range;", "", "requiredFeatureGroup", "Landroidx/camera/core/featuregroup/GroupableFeature;", "preferredFeatureGroup", "setViewPort", "addEffect", "effect", "setFrameRateRange", "setRequiredFeatureGroup", "features", "([Landroidx/camera/core/featuregroup/GroupableFeature;)Landroidx/camera/core/SessionConfig$Builder;", "setPreferredFeatureGroup", "build", "Landroidx/camera/core/SessionConfig;", "camera-core_release"})
    @ExperimentalSessionConfig
    public static final class Builder {
        @NotNull
        private final List<UseCase> useCases;
        @Nullable
        private ViewPort viewPort;
        @NotNull
        private List<CameraEffect> effects;
        @NotNull
        private Range<Integer> frameRateRange;
        @NotNull
        private final List<GroupableFeature> requiredFeatureGroup;
        @NotNull
        private final List<GroupableFeature> preferredFeatureGroup;

        public Builder(@NotNull List<? extends UseCase> useCases) {
            Intrinsics.checkNotNullParameter(useCases, (String)"useCases");
            this.useCases = useCases;
            this.effects = new ArrayList();
            Range<Integer> range = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
            Intrinsics.checkNotNullExpressionValue(range, (String)"FRAME_RATE_RANGE_UNSPECIFIED");
            this.frameRateRange = range;
            this.requiredFeatureGroup = new ArrayList();
            this.preferredFeatureGroup = new ArrayList();
        }

        public Builder(UseCase ... useCases) {
            Intrinsics.checkNotNullParameter((Object)useCases, (String)"useCases");
            this(ArraysKt.toList((Object[])useCases));
        }

        @NotNull
        public final Builder setViewPort(@NotNull ViewPort viewPort) {
            Intrinsics.checkNotNullParameter((Object)viewPort, (String)"viewPort");
            this.viewPort = viewPort;
            return this;
        }

        @NotNull
        public final Builder addEffect(@NotNull CameraEffect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            this.effects.add(effect);
            return this;
        }

        @NotNull
        public final Builder setFrameRateRange(@NotNull Range<Integer> frameRateRange) {
            Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
            this.frameRateRange = frameRateRange;
            return this;
        }

        @NotNull
        public final Builder setRequiredFeatureGroup(GroupableFeature ... features) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            this.requiredFeatureGroup.clear();
            CollectionsKt.addAll((Collection)this.requiredFeatureGroup, (Object[])features);
            return this;
        }

        @NotNull
        public final Builder setPreferredFeatureGroup(GroupableFeature ... features) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            this.preferredFeatureGroup.clear();
            CollectionsKt.addAll((Collection)this.preferredFeatureGroup, (Object[])features);
            return this;
        }

        @NotNull
        public final SessionConfig build() {
            return new SessionConfig(this.useCases, this.viewPort, CollectionsKt.toList((Iterable)this.effects), this.frameRateRange, CollectionsKt.toSet((Iterable)this.requiredFeatureGroup), CollectionsKt.toList((Iterable)this.preferredFeatureGroup));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureTypeInternal.values().length];
            try {
                nArray[FeatureTypeInternal.DYNAMIC_RANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.FPS_RANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.VIDEO_STABILIZATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureTypeInternal.IMAGE_FORMAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

