/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.SingleCloseImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SafeCloseImageReaderProxy
implements ImageReaderProxy {
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private int mOutstandingImages = 0;
    @GuardedBy(value="mLock")
    private boolean mIsClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mImageReaderProxy;
    private final @Nullable Surface mSurface;
    private ForwardingImageProxy.OnImageCloseListener mForwardingImageCloseListener;
    private final ForwardingImageProxy.OnImageCloseListener mImageCloseListener = image -> {
        ForwardingImageProxy.OnImageCloseListener forwardingListener;
        Object object = this.mLock;
        synchronized (object) {
            --this.mOutstandingImages;
            if (this.mIsClosed && this.mOutstandingImages == 0) {
                this.close();
            }
            forwardingListener = this.mForwardingImageCloseListener;
        }
        if (forwardingListener != null) {
            forwardingListener.onImageClose(image);
        }
    };

    public SafeCloseImageReaderProxy(@NonNull ImageReaderProxy imageReaderProxy) {
        this.mImageReaderProxy = imageReaderProxy;
        this.mSurface = imageReaderProxy.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.wrapImageProxy(this.mImageReaderProxy.acquireLatestImage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.wrapImageProxy(this.mImageReaderProxy.acquireNextImage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mImageReaderProxy.close();
        }
    }

    @GuardedBy(value="mLock")
    private @Nullable ImageProxy wrapImageProxy(@Nullable ImageProxy imageProxy) {
        if (imageProxy != null) {
            ++this.mOutstandingImages;
            SingleCloseImageProxy singleCloseImageProxy = new SingleCloseImageProxy(imageProxy);
            singleCloseImageProxy.addOnImageCloseListener(this.mImageCloseListener);
            return singleCloseImageProxy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeClose() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClosed = true;
            this.mImageReaderProxy.clearOnImageAvailableListener();
            if (this.mOutstandingImages == 0) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isClosed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getMaxImages() - this.mOutstandingImages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnImageCloseListener(@NonNull ForwardingImageProxy.OnImageCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mForwardingImageCloseListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReaderProxy.setOnImageAvailableListener(imageReader -> listener.onImageAvailable(this), executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReaderProxy.clearOnImageAvailableListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public @NonNull ImageReaderProxy getImageReaderProxy() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy;
        }
    }
}

