/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.impl.CameraProviderInitRetryPolicy;
import androidx.camera.core.impl.RetryPolicyInternal;
import androidx.camera.core.impl.TimeoutRetryPolicy;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ExperimentalRetryPolicy
public interface RetryPolicy {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final long DEFAULT_RETRY_TIMEOUT_IN_MILLIS = 6000L;
    public static final @NonNull RetryPolicy NEVER = executionState -> RetryConfig.NOT_RETRY;
    public static final @NonNull RetryPolicy DEFAULT = new CameraProviderInitRetryPolicy.Legacy(RetryPolicy.getDefaultRetryTimeoutInMillis());
    public static final @NonNull RetryPolicy RETRY_UNAVAILABLE_CAMERA = new CameraProviderInitRetryPolicy(RetryPolicy.getDefaultRetryTimeoutInMillis());

    public static long getDefaultRetryTimeoutInMillis() {
        return 6000L;
    }

    public @NonNull RetryConfig onRetryDecisionRequested(@NonNull ExecutionState var1);

    default public long getTimeoutInMillis() {
        return 0L;
    }

    @ExperimentalRetryPolicy
    public static final class RetryConfig {
        private static final long MINI_DELAY_MILLIS = 100L;
        private static final long DEFAULT_DELAY_MILLIS = 500L;
        public static final @NonNull RetryConfig NOT_RETRY = new RetryConfig(false, 0L);
        public static final @NonNull RetryConfig DEFAULT_DELAY_RETRY = new RetryConfig(true);
        public static final @NonNull RetryConfig MINI_DELAY_RETRY = new RetryConfig(true, 100L);
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @NonNull RetryConfig COMPLETE_WITHOUT_FAILURE = new RetryConfig(false, 0L, true);
        private final long mDelayInMillis;
        private final boolean mShouldRetry;
        private final boolean mCompleteWithoutFailure;

        public static long getDefaultRetryDelayInMillis() {
            return 500L;
        }

        private RetryConfig(boolean shouldRetry) {
            this(shouldRetry, RetryConfig.getDefaultRetryDelayInMillis());
        }

        private RetryConfig(boolean shouldRetry, long delayInMillis) {
            this(shouldRetry, delayInMillis, false);
        }

        private RetryConfig(boolean shouldRetry, long delayInMillis, boolean completeWithoutFailure) {
            this.mShouldRetry = shouldRetry;
            this.mDelayInMillis = delayInMillis;
            if (completeWithoutFailure) {
                Preconditions.checkArgument((!shouldRetry ? 1 : 0) != 0, (Object)"shouldRetry must be false when completeWithoutFailure is set to true");
            }
            this.mCompleteWithoutFailure = completeWithoutFailure;
        }

        public boolean shouldRetry() {
            return this.mShouldRetry;
        }

        public long getRetryDelayInMillis() {
            return this.mDelayInMillis;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean shouldCompleteWithoutFailure() {
            return this.mCompleteWithoutFailure;
        }

        @ExperimentalRetryPolicy
        public static final class Builder {
            private boolean mShouldRetry = true;
            private long mTimeoutInMillis = RetryConfig.getDefaultRetryDelayInMillis();

            public @NonNull Builder setShouldRetry(boolean shouldRetry) {
                this.mShouldRetry = shouldRetry;
                return this;
            }

            public @NonNull Builder setRetryDelayInMillis(@IntRange(from=100L, to=2000L) long timeoutInMillis) {
                this.mTimeoutInMillis = timeoutInMillis;
                return this;
            }

            public @NonNull RetryConfig build() {
                return new RetryConfig(this.mShouldRetry, this.mTimeoutInMillis);
            }
        }
    }

    @ExperimentalRetryPolicy
    public static interface ExecutionState {
        public static final int STATUS_UNKNOWN_ERROR = 0;
        public static final int STATUS_CONFIGURATION_FAIL = 1;
        public static final int STATUS_CAMERA_UNAVAILABLE = 2;

        public int getStatus();

        public @Nullable Throwable getCause();

        public long getExecutedTimeInMillis();

        public int getNumOfAttempts();

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface Status {
        }
    }

    @ExperimentalRetryPolicy
    public static final class Builder {
        private final RetryPolicy mBasePolicy;
        private long mTimeoutInMillis;

        public Builder(@NonNull RetryPolicy basePolicy) {
            this.mBasePolicy = basePolicy;
            this.mTimeoutInMillis = basePolicy.getTimeoutInMillis();
        }

        public @NonNull Builder setTimeoutInMillis(long timeoutInMillis) {
            this.mTimeoutInMillis = timeoutInMillis;
            return this;
        }

        public @NonNull RetryPolicy build() {
            if (this.mBasePolicy instanceof RetryPolicyInternal) {
                return ((RetryPolicyInternal)this.mBasePolicy).copy(this.mTimeoutInMillis);
            }
            return new TimeoutRetryPolicy(this.mTimeoutInMillis, this.mBasePolicy);
        }
    }
}

