/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.util.Rational;
import androidx.annotation.RestrictTo;
import androidx.camera.core.MeteringPoint;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class MeteringPointFactory {
    private @Nullable Rational mSurfaceAspectRatio;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MeteringPointFactory() {
        this(null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MeteringPointFactory(@Nullable Rational surfaceAspectRatio) {
        this.mSurfaceAspectRatio = surfaceAspectRatio;
    }

    public static float getDefaultPointSize() {
        return 0.15f;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected abstract @NonNull PointF convertPoint(float var1, float var2);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void setSurfaceAspectRatio(@NonNull Rational surfaceAspectRatio) {
        this.mSurfaceAspectRatio = surfaceAspectRatio;
    }

    public final @NonNull MeteringPoint createPoint(float x, float y) {
        return this.createPoint(x, y, MeteringPointFactory.getDefaultPointSize());
    }

    public final @NonNull MeteringPoint createPoint(float x, float y, float size) {
        PointF convertedPoint = this.convertPoint(x, y);
        return new MeteringPoint(convertedPoint.x, convertedPoint.y, size, this.mSurfaceAspectRatio);
    }
}

