/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.LongSparseArray;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MetadataImageReader
implements ImageReaderProxy,
ForwardingImageProxy.OnImageCloseListener {
    private static final String TAG = "MetadataImageReader";
    private final Object mLock = new Object();
    private CameraCaptureCallback mCameraCaptureCallback = new CameraCaptureCallback(){

        @Override
        public void onCaptureCompleted(int captureConfigId, @NonNull CameraCaptureResult cameraCaptureResult) {
            super.onCaptureCompleted(captureConfigId, cameraCaptureResult);
            MetadataImageReader.this.resultIncoming(cameraCaptureResult);
        }
    };
    @GuardedBy(value="mLock")
    private int mUnAcquiredAvailableImageCount = 0;
    private ImageReaderProxy.OnImageAvailableListener mTransformedListener = reader -> {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mUnAcquiredAvailableImageCount;
        }
        this.imageIncoming(reader);
    };
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mImageReaderProxy;
    @GuardedBy(value="mLock")
    @Nullable ImageReaderProxy.OnImageAvailableListener mListener;
    @GuardedBy(value="mLock")
    private @Nullable Executor mExecutor;
    @GuardedBy(value="mLock")
    private final LongSparseArray<ImageInfo> mPendingImageInfos = new LongSparseArray();
    @GuardedBy(value="mLock")
    private final LongSparseArray<ImageProxy> mPendingImages = new LongSparseArray();
    @GuardedBy(value="mLock")
    private int mImageProxiesIndex;
    @GuardedBy(value="mLock")
    private final List<ImageProxy> mMatchedImageProxies;
    @GuardedBy(value="mLock")
    private final List<ImageProxy> mAcquiredImageProxies = new ArrayList<ImageProxy>();

    public MetadataImageReader(int width, int height, int format, int maxImages) {
        this(MetadataImageReader.createImageReaderProxy(width, height, format, maxImages));
    }

    private static ImageReaderProxy createImageReaderProxy(int width, int height, int format, int maxImages) {
        return new AndroidImageReaderProxy(ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages));
    }

    MetadataImageReader(@NonNull ImageReaderProxy imageReaderProxy) {
        this.mImageReaderProxy = imageReaderProxy;
        this.mImageProxiesIndex = 0;
        this.mMatchedImageProxies = new ArrayList<ImageProxy>(this.getMaxImages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.isEmpty()) {
                return null;
            }
            if (this.mImageProxiesIndex >= this.mMatchedImageProxies.size()) {
                throw new IllegalStateException("Maximum image number reached.");
            }
            ArrayList<ImageProxy> toClose = new ArrayList<ImageProxy>();
            for (int i = 0; i < this.mMatchedImageProxies.size() - 1; ++i) {
                if (this.mAcquiredImageProxies.contains(this.mMatchedImageProxies.get(i))) continue;
                toClose.add(this.mMatchedImageProxies.get(i));
            }
            for (ImageProxy image : toClose) {
                image.close();
            }
            this.mImageProxiesIndex = this.mMatchedImageProxies.size() - 1;
            ImageProxy acquiredImage = this.mMatchedImageProxies.get(this.mImageProxiesIndex++);
            this.mAcquiredImageProxies.add(acquiredImage);
            return acquiredImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.isEmpty()) {
                return null;
            }
            if (this.mImageProxiesIndex >= this.mMatchedImageProxies.size()) {
                throw new IllegalStateException("Maximum image number reached.");
            }
            ImageProxy acquiredImage = this.mMatchedImageProxies.get(this.mImageProxiesIndex++);
            this.mAcquiredImageProxies.add(acquiredImage);
            return acquiredImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            ArrayList<ImageProxy> imagesToClose = new ArrayList<ImageProxy>(this.mMatchedImageProxies);
            for (ImageProxy image : imagesToClose) {
                image.close();
            }
            this.mMatchedImageProxies.clear();
            this.mImageReaderProxy.close();
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = (ImageReaderProxy.OnImageAvailableListener)Preconditions.checkNotNull((Object)listener);
            this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
            this.mImageReaderProxy.setOnImageAvailableListener(this.mTransformedListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReaderProxy.clearOnImageAvailableListener();
            this.mListener = null;
            this.mExecutor = null;
            this.mUnAcquiredAvailableImageCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onImageClose(@NonNull ImageProxy image) {
        Object object = this.mLock;
        synchronized (object) {
            this.dequeImageProxy(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueImageProxy(SettableImageProxy image) {
        Executor executor;
        ImageReaderProxy.OnImageAvailableListener listener;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.size() < this.getMaxImages()) {
                image.addOnImageCloseListener(this);
                this.mMatchedImageProxies.add(image);
                listener = this.mListener;
                executor = this.mExecutor;
            } else {
                Logger.d("TAG", "Maximum image number reached.");
                image.close();
                listener = null;
                executor = null;
            }
        }
        if (listener != null) {
            if (executor != null) {
                executor.execute(() -> listener.onImageAvailable(this));
            } else {
                listener.onImageAvailable(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeImageProxy(ImageProxy image) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mMatchedImageProxies.indexOf(image);
            if (index >= 0) {
                this.mMatchedImageProxies.remove(index);
                if (index <= this.mImageProxiesIndex) {
                    --this.mImageProxiesIndex;
                }
            }
            this.mAcquiredImageProxies.remove(image);
            if (this.mUnAcquiredAvailableImageCount > 0) {
                this.imageIncoming(this.mImageReaderProxy);
            }
        }
    }

    public @NonNull CameraCaptureCallback getCameraCaptureCallback() {
        return this.mCameraCaptureCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(ImageReaderProxy imageReader) {
        Object object = this.mLock;
        synchronized (object) {
            ImageProxy image;
            if (this.mClosed) {
                return;
            }
            int numAcquired = this.mPendingImages.size() + this.mMatchedImageProxies.size();
            if (numAcquired >= imageReader.getMaxImages()) {
                Logger.d(TAG, "Skip to acquire the next image because the acquired image count has reached the max images count.");
                return;
            }
            do {
                image = null;
                try {
                    image = imageReader.acquireNextImage();
                }
                catch (IllegalStateException e) {
                    Logger.d(TAG, "Failed to acquire next image.", e);
                }
                finally {
                    if (image != null) {
                        --this.mUnAcquiredAvailableImageCount;
                        ++numAcquired;
                        this.mPendingImages.put(image.getImageInfo().getTimestamp(), (Object)image);
                        this.matchImages();
                    }
                }
            } while (image != null && this.mUnAcquiredAvailableImageCount > 0 && numAcquired < imageReader.getMaxImages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultIncoming(CameraCaptureResult cameraCaptureResult) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mPendingImageInfos.put(cameraCaptureResult.getTimestamp(), (Object)new CameraCaptureResultImageInfo(cameraCaptureResult));
            this.matchImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleData() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingImages.size() == 0 || this.mPendingImageInfos.size() == 0) {
                return;
            }
            Long minImageProxyTimestamp = this.mPendingImages.keyAt(0);
            Long minImageInfoTimestamp = this.mPendingImageInfos.keyAt(0);
            Preconditions.checkArgument((!minImageInfoTimestamp.equals(minImageProxyTimestamp) ? 1 : 0) != 0);
            if (minImageInfoTimestamp > minImageProxyTimestamp) {
                for (int i = this.mPendingImages.size() - 1; i >= 0; --i) {
                    if (this.mPendingImages.keyAt(i) >= minImageInfoTimestamp) continue;
                    ImageProxy imageProxy = (ImageProxy)this.mPendingImages.valueAt(i);
                    imageProxy.close();
                    this.mPendingImages.removeAt(i);
                }
            } else {
                for (int i = this.mPendingImageInfos.size() - 1; i >= 0; --i) {
                    if (this.mPendingImageInfos.keyAt(i) >= minImageProxyTimestamp) continue;
                    this.mPendingImageInfos.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchImages() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mPendingImageInfos.size() - 1; i >= 0; --i) {
                ImageInfo imageInfo = (ImageInfo)this.mPendingImageInfos.valueAt(i);
                long timestamp = imageInfo.getTimestamp();
                ImageProxy image = (ImageProxy)this.mPendingImages.get(timestamp);
                if (image == null) continue;
                this.mPendingImages.remove(timestamp);
                this.mPendingImageInfos.removeAt(i);
                this.enqueueImageProxy(new SettableImageProxy(image, imageInfo));
            }
            this.removeStaleData();
        }
    }
}

