/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Logger {
    private static final int MAX_TAG_LENGTH = 23;
    static final int DEFAULT_MIN_LOG_LEVEL = 3;
    private static int sMinLogLevel = 3;

    private Logger() {
    }

    private static boolean isLogLevelEnabled(@NonNull String truncatedTag, int logLevel) {
        return sMinLogLevel <= logLevel || Log.isLoggable((String)truncatedTag, (int)logLevel);
    }

    static void setMinLogLevel(@IntRange(from=3L, to=6L) int logLevel) {
        sMinLogLevel = logLevel;
    }

    static int getMinLogLevel() {
        return sMinLogLevel;
    }

    static void resetMinLogLevel() {
        sMinLogLevel = 3;
    }

    public static boolean isVerboseEnabled(@NonNull String tag) {
        return Logger.isLogLevelEnabled(Logger.truncateTag(tag), 2);
    }

    public static boolean isDebugEnabled(@NonNull String tag) {
        return Logger.isLogLevelEnabled(Logger.truncateTag(tag), 3);
    }

    public static boolean isInfoEnabled(@NonNull String tag) {
        return Logger.isLogLevelEnabled(Logger.truncateTag(tag), 4);
    }

    public static boolean isWarnEnabled(@NonNull String tag) {
        return Logger.isLogLevelEnabled(Logger.truncateTag(tag), 5);
    }

    public static boolean isErrorEnabled(@NonNull String tag) {
        return Logger.isLogLevelEnabled(Logger.truncateTag(tag), 6);
    }

    public static void d(@NonNull String tag, @NonNull String message) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 3)) {
            Log.d((String)truncatedTag, (String)message);
        }
    }

    public static void d(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 3)) {
            Log.d((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 4)) {
            Log.i((String)truncatedTag, (String)message);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 4)) {
            Log.i((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public static void w(@NonNull String tag, @NonNull String message) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 5)) {
            Log.w((String)truncatedTag, (String)message);
        }
    }

    public static void w(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 5)) {
            Log.w((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public static void e(@NonNull String tag, @NonNull String message) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 6)) {
            Log.e((String)truncatedTag, (String)message);
        }
    }

    public static void e(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
        String truncatedTag = Logger.truncateTag(tag);
        if (Logger.isLogLevelEnabled(truncatedTag, 6)) {
            Log.e((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    private static @NonNull String truncateTag(@NonNull String tag) {
        if (Build.VERSION.SDK_INT <= 25 && 23 < tag.length()) {
            return tag.substring(0, 23);
        }
        return tag;
    }
}

