/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraClosedException;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ImageCaptureCapabilities;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageCaptureLatencyEstimate;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.Logger;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.feature.ImageFormatFeature;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.PostviewSettings;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.AdapterCameraInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.StreamUseCase;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.IoConfig;
import androidx.camera.core.internal.ScreenFlashWrapper;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.compat.quirk.SoftwareJpegEncodingPreferredQuirk;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ImageCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    @ExperimentalZeroShutterLag
    public static final int CAPTURE_MODE_ZERO_SHUTTER_LAG = 2;
    private static final int FLASH_MODE_UNKNOWN = -1;
    public static final int FLASH_MODE_AUTO = 0;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    public static final int FLASH_MODE_SCREEN = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final long SCREEN_FLASH_UI_APPLY_TIMEOUT_SECONDS = 3L;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_ONE_SHOT_FLASH = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_USE_TORCH_AS_FLASH = 1;
    public static final int OUTPUT_FORMAT_JPEG = 0;
    public static final int OUTPUT_FORMAT_JPEG_ULTRA_HDR = 1;
    public static final int OUTPUT_FORMAT_RAW = 2;
    public static final int OUTPUT_FORMAT_RAW_JPEG = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageCapture";
    private static final int MAX_IMAGES = 2;
    private static final byte JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    private static final byte JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;
    private static final int DEFAULT_CAPTURE_MODE = 1;
    private static final int DEFAULT_FLASH_MODE = 2;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    private final ImageReaderProxy.OnImageAvailableListener mClosingListener = imageReader -> {
        try (ImageProxy image = imageReader.acquireLatestImage();){
            Log.d((String)TAG, (String)("Discarding ImageProxy which was inadvertently acquired: " + image));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
        }
    };
    private final int mCaptureMode;
    @GuardedBy(value="mLockedFlashMode")
    private final AtomicReference<Integer> mLockedFlashMode = new AtomicReference<Object>(null);
    private final int mFlashType;
    @GuardedBy(value="mLockedFlashMode")
    private int mFlashMode = -1;
    private Rational mCropAspectRatio = null;
    private @NonNull ScreenFlashWrapper mScreenFlashWrapper;
    SessionConfig.Builder mSessionConfigBuilder;
    private @Nullable ImagePipeline mImagePipeline;
    private @Nullable TakePictureManager mTakePictureManager;
    private @Nullable SessionConfig.CloseableErrorListener mCloseableErrorListener;
    private final ImageCaptureControl mImageCaptureControl = new ImageCaptureControl(){

        @Override
        @MainThread
        public void lockFlashMode() {
            ImageCapture.this.lockFlashMode();
        }

        @Override
        @MainThread
        public void unlockFlashMode() {
            ImageCapture.this.unlockFlashMode();
        }

        @Override
        @MainThread
        public @NonNull ListenableFuture<Void> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            return ImageCapture.this.submitStillCaptureRequest(captureConfigs);
        }
    };

    ImageCapture(@NonNull ImageCaptureConfig userConfig) {
        super(userConfig);
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        this.mCaptureMode = useCaseConfig.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE) ? useCaseConfig.getCaptureMode() : 1;
        this.mFlashType = useCaseConfig.getFlashType(0);
        this.mScreenFlashWrapper = ScreenFlashWrapper.from(useCaseConfig.getScreenFlash());
    }

    private boolean isSessionProcessorEnabledInCurrentCamera() {
        if (this.getCamera() == null) {
            return false;
        }
        CameraConfig cameraConfig = this.getCamera().getExtendedConfig();
        return cameraConfig.getSessionProcessor(null) != null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), this.getCaptureMode());
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        this.applyFeatureGroupToConfig(builder);
        if (cameraInfo.getCameraQuirks().contains(SoftwareJpegEncodingPreferredQuirk.class)) {
            if (Boolean.FALSE.equals(builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true))) {
                Logger.w(TAG, "Device quirk suggests software JPEG encoder, but it has been explicitly disabled.");
            } else {
                Logger.i(TAG, "Requesting software JPEG due to device quirk.");
                builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true);
            }
        }
        boolean useSoftwareJpeg = this.enforceSoftwareJpegConstraints(builder.getMutableConfig());
        Integer bufferFormat = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            Preconditions.checkArgument((!this.isSessionProcessorEnabledInCurrentCamera() || bufferFormat == 256 ? 1 : 0) != 0, (Object)"Cannot set non-JPEG buffer format with Extensions enabled.");
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, useSoftwareJpeg ? 35 : bufferFormat);
        } else if (ImageCapture.isOutputFormatRaw(builder.getMutableConfig())) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 32);
        } else if (ImageCapture.isOutputFormatRawJpeg(builder.getMutableConfig())) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 32);
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_SECONDARY_INPUT_FORMAT, 256);
        } else if (ImageCapture.isOutputFormatUltraHdr(builder.getMutableConfig())) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 4101);
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, DynamicRange.UNSPECIFIED);
        } else if (useSoftwareJpeg) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
        } else {
            List supportedSizes = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, null);
            if (supportedSizes == null) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 256)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 35)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            }
        }
        return builder.getUseCaseConfig();
    }

    @OptIn(markerClass={ExperimentalSessionConfig.class})
    private void applyFeatureGroupToConfig(@NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        Set<@NonNull GroupableFeature> featureGroup = this.getFeatureGroup();
        if (featureGroup != null) {
            int imageCaptureOutputFormat = 0;
            for (GroupableFeature feature : featureGroup) {
                if (!(feature instanceof ImageFormatFeature)) continue;
                imageCaptureOutputFormat = ((ImageFormatFeature)feature).getImageCaptureOutputFormat();
            }
            builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, imageCaptureOutputFormat);
        }
    }

    private static boolean isImageFormatSupported(List<Pair<Integer, Size[]>> supportedSizes, int imageFormat) {
        if (supportedSizes == null) {
            return false;
        }
        for (Pair<Integer, Size[]> supportedSize : supportedSizes) {
            if (!((Integer)supportedSize.first).equals(imageFormat)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputFormatUltraHdr(@NonNull MutableConfig config) {
        return Objects.equals(config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, null), 1);
    }

    private static boolean isOutputFormatRaw(@NonNull MutableConfig config) {
        return Objects.equals(config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, null), 2);
    }

    private static boolean isOutputFormatRawJpeg(@NonNull MutableConfig config) {
        return Objects.equals(config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, null), 3);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onCameraControlReady() {
        Logger.d(TAG, "onCameraControlReady");
        this.trySetFlashModeToCameraControl();
        this.setScreenFlashToCameraControl();
    }

    private int getCameraLens() {
        CameraInternal camera = this.getCamera();
        if (camera != null) {
            return camera.getCameraInfo().getLensFacing();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            return this.mFlashMode != -1 ? this.mFlashMode : ((ImageCaptureConfig)this.getCurrentConfig()).getFlashMode(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlashMode(int flashMode) {
        Logger.d(TAG, "setFlashMode: flashMode = " + flashMode);
        if (flashMode != 0 && flashMode != 1 && flashMode != 2) {
            if (flashMode == 3) {
                if (this.mScreenFlashWrapper.getBaseScreenFlash() == null) {
                    throw new IllegalArgumentException("ScreenFlash not set for FLASH_MODE_SCREEN");
                }
                if (this.getCamera() != null && this.getCameraLens() != 0) {
                    throw new IllegalArgumentException("Not a front camera despite setting FLASH_MODE_SCREEN");
                }
            } else {
                throw new IllegalArgumentException("Invalid flash mode: " + flashMode);
            }
        }
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            this.mFlashMode = flashMode;
            this.trySetFlashModeToCameraControl();
        }
    }

    public void setScreenFlash(@Nullable ScreenFlash screenFlash) {
        this.mScreenFlashWrapper = ScreenFlashWrapper.from(screenFlash);
        this.setScreenFlashToCameraControl();
    }

    public @Nullable ScreenFlash getScreenFlash() {
        return this.mScreenFlashWrapper.getBaseScreenFlash();
    }

    private void setScreenFlashToCameraControl() {
        this.setScreenFlashToCameraControl(this.mScreenFlashWrapper);
    }

    private void setScreenFlashToCameraControl(@Nullable ScreenFlash screenFlash) {
        this.getCameraControl().setScreenFlash(screenFlash);
    }

    public void setCropAspectRatio(@NonNull Rational aspectRatio) {
        this.mCropAspectRatio = aspectRatio;
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        int oldRotation = this.getTargetRotation();
        if (this.setTargetRotationInternal(rotation) && this.mCropAspectRatio != null) {
            int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
            int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(rotation);
            this.mCropAspectRatio = ImageUtil.getRotatedAspectRatio(Math.abs(newRotationDegrees - oldRotationDegrees), this.mCropAspectRatio);
        }
    }

    public int getCaptureMode() {
        return this.mCaptureMode;
    }

    @IntRange(from=1L, to=100L)
    public int getJpegQuality() {
        return this.getJpegQualityInternal();
    }

    public @Nullable ResolutionInfo getResolutionInfo() {
        return this.getResolutionInfoInternal();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @Nullable ResolutionInfo getResolutionInfoInternal() {
        CameraInternal camera = this.getCamera();
        Size resolution = this.getAttachedSurfaceResolution();
        if (camera == null || resolution == null) {
            return null;
        }
        Rect cropRect = this.getViewPortCropRect();
        Rational cropAspectRatio = this.mCropAspectRatio;
        if (cropRect == null) {
            cropRect = cropAspectRatio != null ? ImageUtil.computeCropRectFromAspectRatio(resolution, cropAspectRatio) : new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
        }
        int rotationDegrees = this.getRelativeRotation(camera);
        return new ResolutionInfo(resolution, Objects.requireNonNull(cropRect), rotationDegrees);
    }

    public @Nullable ResolutionSelector getResolutionSelector() {
        return ((ImageOutputConfig)((Object)this.getCurrentConfig())).getResolutionSelector(null);
    }

    public int getOutputFormat() {
        return (Integer)Preconditions.checkNotNull((Object)this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, 0));
    }

    public void takePicture(@NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(executor, callback));
            return;
        }
        this.takePictureInternal(executor, callback, null, null, null);
    }

    public void takePicture(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull OnImageSavedCallback imageSavedCallback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(outputFileOptions, executor, imageSavedCallback));
            return;
        }
        this.takePictureInternal(executor, null, imageSavedCallback, outputFileOptions, null);
    }

    public void takePicture(@NonNull OutputFileOptions rawOutputFileOptions, @NonNull OutputFileOptions jpegOutputFileOptions, @NonNull Executor executor, @NonNull OnImageSavedCallback imageSavedCallback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(rawOutputFileOptions, jpegOutputFileOptions, executor, imageSavedCallback));
            return;
        }
        this.takePictureInternal(executor, null, imageSavedCallback, rawOutputFileOptions, jpegOutputFileOptions);
    }

    public static @NonNull ImageCaptureCapabilities getImageCaptureCapabilities(@NonNull CameraInfo cameraInfo) {
        return new ImageCaptureCapabilitiesImpl(cameraInfo);
    }

    static @NonNull Rect computeDispatchCropRect(@Nullable Rect viewPortCropRect, @Nullable Rational cropAspectRatio, int rotationDegrees, @NonNull Size dispatchResolution, int dispatchRotationDegrees) {
        if (viewPortCropRect != null) {
            return ImageUtil.computeCropRectFromDispatchInfo(viewPortCropRect, rotationDegrees, dispatchResolution, dispatchRotationDegrees);
        }
        if (cropAspectRatio != null) {
            Rational aspectRatio = cropAspectRatio;
            if (dispatchRotationDegrees % 180 != 0) {
                aspectRatio = new Rational(cropAspectRatio.getDenominator(), cropAspectRatio.getNumerator());
            }
            if (ImageUtil.isAspectRatioValid(dispatchResolution, aspectRatio)) {
                return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(dispatchResolution, aspectRatio));
            }
        }
        return new Rect(0, 0, dispatchResolution.getWidth(), dispatchResolution.getHeight());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    public void onSessionStop() {
        this.abortImageCaptureRequests();
    }

    @UiThread
    private void abortImageCaptureRequests() {
        this.mScreenFlashWrapper.completePendingTasks();
        if (this.mTakePictureManager != null) {
            this.mTakePictureManager.abortRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.mLockedFlashMode.set(this.getFlashMode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            Integer lockedFlashMode = this.mLockedFlashMode.getAndSet(null);
            if (lockedFlashMode == null) {
                return;
            }
            if (lockedFlashMode.intValue() != this.getFlashMode()) {
                this.trySetFlashModeToCameraControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetFlashModeToCameraControl() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.getCameraControl().setFlashMode(this.getFlashMode());
        }
    }

    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    @IntRange(from=1L, to=100L)
    private int getJpegQualityInternal() {
        ImageCaptureConfig imageCaptureConfig = (ImageCaptureConfig)this.getCurrentConfig();
        if (imageCaptureConfig.containsOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY)) {
            return imageCaptureConfig.getJpegQuality();
        }
        switch (this.mCaptureMode) {
            case 0: {
                return 100;
            }
            case 1: 
            case 2: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mCaptureMode + " is invalid");
    }

    public @NonNull String toString() {
        return "ImageCapture:" + this.getName();
    }

    static int getError(Throwable throwable) {
        if (throwable instanceof CameraClosedException) {
            return 3;
        }
        if (throwable instanceof ImageCaptureException) {
            return ((ImageCaptureException)throwable).getImageCaptureError();
        }
        return 0;
    }

    boolean enforceSoftwareJpegConstraints(@NonNull MutableConfig mutableConfig) {
        if (Boolean.TRUE.equals(mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false))) {
            Integer bufferFormat;
            boolean supported = true;
            if (this.isSessionProcessorEnabledInCurrentCamera()) {
                Logger.w(TAG, "Software JPEG cannot be used with Extensions.");
                supported = false;
            }
            if ((bufferFormat = (Integer)mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null)) != null && bufferFormat != 256) {
                Logger.w(TAG, "Software JPEG cannot be used with non-JPEG output buffer format.");
                supported = false;
            }
            if (!supported) {
                Logger.w(TAG, "Unable to support software JPEG. Disabling.");
                mutableConfig.insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false);
            }
            return supported;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onUnbind() {
        this.abortImageCaptureRequests();
        this.clearPipeline();
        this.setScreenFlashToCameraControl(null);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onBind() {
        CameraInternal camera = this.getCamera();
        Preconditions.checkNotNull((Object)camera, (Object)"Attached camera cannot be null");
        if (this.getFlashMode() == 3 && this.getCameraLens() != 0) {
            throw new IllegalArgumentException("Not a front camera despite setting FLASH_MODE_SCREEN in ImageCapture");
        }
    }

    private @Nullable SessionProcessor getSessionProcessor() {
        CameraConfig cameraConfig = this.getCamera().getExtendedConfig();
        return cameraConfig.getSessionProcessor(null);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        Logger.d(TAG, "onSuggestedStreamSpecUpdated: primaryStreamSpec = " + primaryStreamSpec + ", secondaryStreamSpec " + secondaryStreamSpec);
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageCaptureConfig)this.getCurrentConfig(), primaryStreamSpec);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        this.notifyActive();
        return primaryStreamSpec;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    @MainThread
    private SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageCaptureConfig config, @NonNull StreamSpec streamSpec) {
        boolean isVirtualCamera;
        Threads.checkMainThread();
        Log.d((String)TAG, (String)String.format("createPipeline(cameraId: %s, streamSpec: %s)", cameraId, streamSpec));
        Size resolution = streamSpec.getResolution();
        boolean bl = isVirtualCamera = !Objects.requireNonNull(this.getCamera()).getHasTransform();
        if (this.mImagePipeline != null) {
            Preconditions.checkState((boolean)isVirtualCamera);
            this.mImagePipeline.close();
        }
        Set<Integer> supportedOutputFormats = ImageCapture.getImageCaptureCapabilities(this.getCamera().getCameraInfo()).getSupportedOutputFormats();
        Preconditions.checkArgument((boolean)supportedOutputFormats.contains(this.getOutputFormat()), (Object)("The specified output format (" + this.getOutputFormat() + ") is not supported by current configuration. Supported output formats: " + supportedOutputFormats));
        PostviewSettings postviewSettings = this.isPostviewEnabled() ? this.calculatePostviewSettings(config.getInputFormat(), resolution) : null;
        CameraCharacteristics cameraCharacteristics = null;
        if (this.getCamera() != null) {
            try {
                Object obj = this.getCamera().getCameraInfoInternal().getCameraCharacteristics();
                if (obj instanceof CameraCharacteristics) {
                    cameraCharacteristics = (CameraCharacteristics)obj;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"getCameraCharacteristics failed", (Throwable)e);
            }
        }
        this.mImagePipeline = new ImagePipeline(config, resolution, cameraCharacteristics, this.getEffect(), isVirtualCamera, postviewSettings);
        if (this.mTakePictureManager == null) {
            this.mTakePictureManager = this.getCurrentConfig().getTakePictureManagerProvider().newInstance(this.mImageCaptureControl);
        }
        this.mTakePictureManager.setImagePipeline(this.mImagePipeline);
        SessionConfig.Builder sessionConfigBuilder = this.mImagePipeline.createSessionConfigBuilder(streamSpec.getResolution());
        sessionConfigBuilder.setSessionType(streamSpec.getSessionType());
        if (Build.VERSION.SDK_INT >= 23 && this.getCaptureMode() == 2 && !streamSpec.getZslDisabled()) {
            this.getCameraControl().addZslConfig(sessionConfigBuilder);
        }
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
        }
        this.mCloseableErrorListener = new SessionConfig.CloseableErrorListener((sessionConfig, error) -> {
            if (this.getCamera() == null) {
                return;
            }
            this.mTakePictureManager.pause();
            this.clearPipeline(true);
            this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageCaptureConfig)this.getCurrentConfig(), (StreamSpec)Preconditions.checkNotNull((Object)this.getAttachedStreamSpec()));
            this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
            this.notifyReset();
            this.mTakePictureManager.resume();
        });
        sessionConfigBuilder.setErrorListener(this.mCloseableErrorListener);
        return sessionConfigBuilder;
    }

    private @Nullable PostviewSettings calculatePostviewSettings(int stillImageFormat, @NonNull Size targetResolution) {
        SessionProcessor sessionProcessor = this.getSessionProcessor();
        if (sessionProcessor == null) {
            return null;
        }
        Map<Integer, List<Size>> formatSizesMap = sessionProcessor.getSupportedPostviewSize(targetResolution);
        int format = 0;
        ArrayList<Integer> supportedPostviewFormats = new ArrayList<Integer>();
        if (this.isPostviewImageFormatSupported(formatSizesMap, 35)) {
            supportedPostviewFormats.add(35);
        }
        if (this.isPostviewImageFormatSupported(formatSizesMap, 256)) {
            supportedPostviewFormats.add(256);
        }
        if (this.isPostviewImageFormatSupported(formatSizesMap, 4101)) {
            supportedPostviewFormats.add(4101);
        }
        if (!supportedPostviewFormats.isEmpty()) {
            format = this.getCamera().getExtendedConfig().getPostviewFormatSelector().select(stillImageFormat, supportedPostviewFormats);
        }
        if (format == 0) {
            return null;
        }
        List<Size> sizes = formatSizesMap.get(format);
        ResolutionSelector postviewSizeSelector = this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, null);
        if (postviewSizeSelector != null) {
            Collections.sort(sizes, new CompareSizesByArea(true));
            CameraInternal camera = this.getCamera();
            Rect sensorRect = camera.getCameraInfoInternal().getSensorRect();
            CameraInfoInternal cameraInfo = camera.getCameraInfoInternal();
            Rational fullFov = new Rational(sensorRect.width(), sensorRect.height());
            List<Size> result = SupportedOutputSizesSorter.sortSupportedOutputSizesByResolutionSelector(postviewSizeSelector, sizes, null, this.getTargetRotation(), fullFov, cameraInfo.getSensorRotationDegrees(), cameraInfo.getLensFacing());
            if (result.isEmpty()) {
                throw new IllegalArgumentException("The postview ResolutionSelector cannot select a valid size for the postview.");
            }
            return PostviewSettings.create(result.get(0), format);
        }
        return PostviewSettings.create(Collections.max(sizes, new CompareSizesByArea()), format);
    }

    private boolean isPostviewImageFormatSupported(@NonNull Map<Integer, List<Size>> formatSizesMap, int format) {
        return formatSizesMap.containsKey(format) && !formatSizesMap.get(format).isEmpty();
    }

    @MainThread
    private void takePictureInternal(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback, @Nullable OutputFileOptions outputFileOptions, @Nullable OutputFileOptions secondaryOutputFileOptions) {
        boolean isSimultaneousCapture;
        Threads.checkMainThread();
        if (this.getFlashMode() == 3 && this.mScreenFlashWrapper.getBaseScreenFlash() == null) {
            throw new IllegalArgumentException("ScreenFlash not set for FLASH_MODE_SCREEN");
        }
        Log.d((String)TAG, (String)"takePictureInternal");
        CameraInternal camera = this.getCamera();
        if (camera == null || !this.isInSession()) {
            this.sendInvalidCameraError(executor, inMemoryCallback, onDiskCallback);
            return;
        }
        boolean bl = isSimultaneousCapture = this.getCurrentConfig().getSecondaryInputFormat() != 0;
        if (isSimultaneousCapture && secondaryOutputFileOptions == null) {
            throw new IllegalArgumentException("Simultaneous capture RAW and JPEG needs two output file options");
        }
        if (!isSimultaneousCapture && secondaryOutputFileOptions != null) {
            throw new IllegalArgumentException("Non simultaneous capture cannot have two output file options");
        }
        Objects.requireNonNull(this.mTakePictureManager).offerRequest(TakePictureRequest.of(executor, inMemoryCallback, onDiskCallback, outputFileOptions, secondaryOutputFileOptions, this.getTakePictureCropRect(), this.getSensorToBufferTransformMatrix(), this.getRelativeRotation(camera), this.getJpegQualityInternal(), this.getCaptureMode(), isSimultaneousCapture, this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks()));
    }

    private void sendInvalidCameraError(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback) {
        ImageCaptureException exception = new ImageCaptureException(4, "Not bound to a valid Camera [" + this + "]", null);
        if (inMemoryCallback != null) {
            inMemoryCallback.onError(exception);
        } else if (onDiskCallback != null) {
            onDiskCallback.onError(exception);
        } else {
            throw new IllegalArgumentException("Must have either in-memory or on-disk callback.");
        }
    }

    private @NonNull Rect getTakePictureCropRect() {
        Rect rect = this.getViewPortCropRect();
        Size resolution = Objects.requireNonNull(this.getAttachedSurfaceResolution());
        if (rect != null) {
            return rect;
        }
        if (ImageUtil.isAspectRatioValid(this.mCropAspectRatio)) {
            int rotationDegrees = this.getRelativeRotation(Objects.requireNonNull(this.getCamera()));
            Rational rotatedAspectRatio = new Rational(this.mCropAspectRatio.getDenominator(), this.mCropAspectRatio.getNumerator());
            Rational sensorCropRatio = TransformUtils.is90or270(rotationDegrees) ? rotatedAspectRatio : this.mCropAspectRatio;
            return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(resolution, sensorCropRatio));
        }
        return new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
    }

    @MainThread
    private void clearPipeline() {
        this.clearPipeline(false);
    }

    @MainThread
    private void clearPipeline(boolean keepTakePictureManager) {
        Log.d((String)TAG, (String)"clearPipeline");
        Threads.checkMainThread();
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
            this.mCloseableErrorListener = null;
        }
        if (this.mImagePipeline != null) {
            this.mImagePipeline.close();
            this.mImagePipeline = null;
        }
        if (!keepTakePictureManager && this.mTakePictureManager != null) {
            this.mTakePictureManager.abortRequests();
            this.mTakePictureManager = null;
        }
        this.getCameraControl().clearZslConfig();
    }

    @MainThread
    ListenableFuture<Void> submitStillCaptureRequest(@NonNull List<CaptureConfig> captureConfigs) {
        Threads.checkMainThread();
        return Futures.transform(this.getCameraControl().submitStillCaptureRequests(captureConfigs, this.mCaptureMode, this.mFlashType), input -> null, CameraXExecutors.directExecutor());
    }

    @VisibleForTesting
    boolean isProcessingPipelineEnabled() {
        return this.mImagePipeline != null && this.mTakePictureManager != null;
    }

    @VisibleForTesting
    @Nullable ImagePipeline getImagePipeline() {
        return this.mImagePipeline;
    }

    @VisibleForTesting
    @NonNull TakePictureManager getTakePictureManager() {
        return Objects.requireNonNull(this.mTakePictureManager);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(4);
        return targets;
    }

    public @NonNull ImageCaptureLatencyEstimate getRealtimeCaptureLatencyEstimate() {
        Pair<Long, Long> latencyEstimate;
        CameraInternal camera = this.getCamera();
        if (camera == null) {
            return ImageCaptureLatencyEstimate.UNDEFINED_IMAGE_CAPTURE_LATENCY;
        }
        CameraConfig config = camera.getExtendedConfig();
        SessionProcessor sessionProcessor = config.getSessionProcessor(null);
        Pair<Long, Long> pair = latencyEstimate = sessionProcessor != null ? sessionProcessor.getRealtimeCaptureLatency() : null;
        if (latencyEstimate == null) {
            return ImageCaptureLatencyEstimate.UNDEFINED_IMAGE_CAPTURE_LATENCY;
        }
        return new ImageCaptureLatencyEstimate((Long)latencyEstimate.first, (Long)latencyEstimate.second);
    }

    public boolean isPostviewEnabled() {
        return this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_ENABLED, false);
    }

    public @Nullable ResolutionSelector getPostviewResolutionSelector() {
        return this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageCaptureConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 4;
        private static final StreamUseCase DEFAULT_STREAM_USE_CASE = StreamUseCase.STILL_CAPTURE;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final int DEFAULT_OUTPUT_FORMAT = 0;
        private static final ResolutionSelector DEFAULT_RESOLUTION_SELECTOR = new ResolutionSelector.Builder().setAspectRatioStrategy(AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY).setResolutionStrategy(ResolutionStrategy.HIGHEST_AVAILABLE_STRATEGY).build();
        private static final ImageCaptureConfig DEFAULT_CONFIG;
        private static final DynamicRange DEFAULT_DYNAMIC_RANGE;

        @Override
        public @NonNull ImageCaptureConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            DEFAULT_DYNAMIC_RANGE = DynamicRange.SDR;
            Builder builder = new Builder().setSurfaceOccupancyPriority(4).setStreamUseCase(DEFAULT_STREAM_USE_CASE).setTargetAspectRatio(0).setResolutionSelector(DEFAULT_RESOLUTION_SELECTOR).setOutputFormat(0).setDynamicRange(DEFAULT_DYNAMIC_RANGE);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface ScreenFlash {
        @UiThread
        public void apply(long var1, @NonNull ScreenFlashListener var3);

        @UiThread
        public void clear();
    }

    public static final class Builder
    implements UseCaseConfig.Builder<ImageCapture, ImageCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    IoConfig.Builder<Builder>,
    ImageInputConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setCaptureType(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE);
            this.setTargetClass((Class)ImageCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @NonNull Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        static @NonNull Builder fromConfig(@NonNull ImageCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull ImageCaptureConfig getUseCaseConfig() {
            return new ImageCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        public @NonNull ImageCapture build() {
            Integer bufferFormat = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
            if (bufferFormat != null) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, bufferFormat);
            } else if (ImageCapture.isOutputFormatRaw(this.getMutableConfig())) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 32);
            } else if (ImageCapture.isOutputFormatRawJpeg(this.getMutableConfig())) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 32);
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_SECONDARY_INPUT_FORMAT, 256);
            } else if (ImageCapture.isOutputFormatUltraHdr(this.getMutableConfig())) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 4101);
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, DynamicRange.UNSPECIFIED);
            } else {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            }
            ImageCaptureConfig imageCaptureConfig = this.getUseCaseConfig();
            ImageOutputConfig.validateConfig(imageCaptureConfig);
            ImageCapture imageCapture = new ImageCapture(imageCaptureConfig);
            Size targetResolution = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null);
            if (targetResolution != null) {
                imageCapture.setCropAspectRatio(new Rational(targetResolution.getWidth(), targetResolution.getHeight()));
            }
            Preconditions.checkNotNull((Object)this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, CameraXExecutors.ioExecutor()), (Object)"The IO executor can't be null");
            if (this.getMutableConfig().containsOption(ImageCaptureConfig.OPTION_FLASH_MODE)) {
                Integer flashMode = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_FLASH_MODE);
                if (flashMode == null || flashMode != 0 && flashMode != 1 && flashMode != 3 && flashMode != 2) {
                    throw new IllegalArgumentException("The flash mode is not allowed to set: " + flashMode);
                }
                if (flashMode == 3 && this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_SCREEN_FLASH, null) == null) {
                    throw new IllegalArgumentException("The flash mode is not allowed to set to FLASH_MODE_SCREEN without setting ScreenFlash");
                }
            }
            return imageCapture;
        }

        public @NonNull Builder setCaptureMode(int captureMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, captureMode);
            return this;
        }

        public @NonNull Builder setFlashMode(int flashMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_MODE, flashMode);
            return this;
        }

        public @NonNull Builder setScreenFlash(@NonNull ScreenFlash screenFlash) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SCREEN_FLASH, screenFlash);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setBufferFormat(int bufferImageFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, bufferImageFormat);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setTargetClass(@NonNull Class<ImageCapture> targetClass) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        public @NonNull Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @Deprecated
        public @NonNull Builder setTargetAspectRatio(int aspectRatio) {
            if (aspectRatio == -1) {
                aspectRatio = 0;
            }
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        public @NonNull Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setMirrorMode(int mirrorMode) {
            throw new UnsupportedOperationException("setMirrorMode is not supported.");
        }

        @Override
        @Deprecated
        public @NonNull Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        public @NonNull Builder setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        public @NonNull Builder setPostviewEnabled(boolean postviewEnabled) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_POSTVIEW_ENABLED, postviewEnabled);
            return this;
        }

        public @NonNull Builder setPostviewResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSoftwareJpegEncoderRequested(boolean requestSoftwareJpeg) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, requestSoftwareJpeg);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setFlashType(int flashType) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_TYPE, flashType);
            return this;
        }

        public @NonNull Builder setJpegQuality(@IntRange(from=1L, to=100L) int jpegQuality) {
            Preconditions.checkArgumentInRange((int)jpegQuality, (int)1, (int)100, (String)"jpegQuality");
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY, jpegQuality);
            return this;
        }

        @Override
        public @NonNull Builder setIoExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        public @NonNull Builder setOutputFormat(int outputFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT, outputFormat);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, captureType);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setStreamUseCase(@NonNull StreamUseCase streamUseCase) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_STREAM_USE_CASE, streamUseCase);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public @NonNull Builder setDynamicRange(@NonNull DynamicRange dynamicRange) {
            this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, dynamicRange);
            return this;
        }
    }

    public static abstract class OnImageCapturedCallback {
        public void onCaptureStarted() {
        }

        public void onCaptureSuccess(@NonNull ImageProxy image) {
        }

        public void onError(@NonNull ImageCaptureException exception) {
        }

        public void onCaptureProcessProgressed(int progress) {
        }

        public void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        }
    }

    public static interface OnImageSavedCallback {
        default public void onCaptureStarted() {
        }

        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(@NonNull ImageCaptureException var1);

        default public void onCaptureProcessProgressed(int progress) {
        }

        default public void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        }
    }

    public static final class OutputFileOptions {
        private final @Nullable File mFile;
        private final @Nullable ContentResolver mContentResolver;
        private final @Nullable Uri mSaveCollection;
        private final @Nullable ContentValues mContentValues;
        private final @Nullable OutputStream mOutputStream;
        private final @NonNull Metadata mMetadata;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream, @Nullable Metadata metadata) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
            this.mMetadata = metadata == null ? new Metadata() : metadata;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @Nullable File getFile() {
            return this.mFile;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @Nullable ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @Nullable Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @Nullable ContentValues getContentValues() {
            return this.mContentValues;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @Nullable OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Metadata getMetadata() {
            return this.mMetadata;
        }

        public @NonNull String toString() {
            return "OutputFileOptions{mFile=" + this.mFile + ", mContentResolver=" + this.mContentResolver + ", mSaveCollection=" + this.mSaveCollection + ", mContentValues=" + this.mContentValues + ", mOutputStream=" + this.mOutputStream + ", mMetadata=" + this.mMetadata + "}";
        }

        public static final class Builder {
            private @Nullable File mFile;
            private @Nullable ContentResolver mContentResolver;
            private @Nullable Uri mSaveCollection;
            private @Nullable ContentValues mContentValues;
            private @Nullable OutputStream mOutputStream;
            private @Nullable Metadata mMetadata;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@NonNull OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            public @NonNull Builder setMetadata(@NonNull Metadata metadata) {
                this.mMetadata = metadata;
                return this;
            }

            public @NonNull OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream, this.mMetadata);
            }
        }
    }

    private static class ImageCaptureCapabilitiesImpl
    implements ImageCaptureCapabilities {
        private final CameraInfo mCameraInfo;

        ImageCaptureCapabilitiesImpl(@NonNull CameraInfo cameraInfo) {
            this.mCameraInfo = cameraInfo;
        }

        @Override
        public boolean isPostviewSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                return ((CameraInfoInternal)this.mCameraInfo).isPostviewSupported();
            }
            return false;
        }

        @Override
        public boolean isCaptureProcessProgressSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                return ((CameraInfoInternal)this.mCameraInfo).isCaptureProcessProgressSupported();
            }
            return false;
        }

        @Override
        public @NonNull Set<Integer> getSupportedOutputFormats() {
            Set<Integer> outputFormatsFromAdapterCameraInfo = this.getSupportedOutputFormatsFromAdapterCameraInfo();
            if (outputFormatsFromAdapterCameraInfo != null) {
                return outputFormatsFromAdapterCameraInfo;
            }
            HashSet<Integer> formats = new HashSet<Integer>();
            formats.add(0);
            if (this.isUltraHdrSupported()) {
                formats.add(1);
            }
            if (this.isRawSupported()) {
                formats.add(2);
                formats.add(3);
            }
            return formats;
        }

        private boolean isUltraHdrSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                CameraInfoInternal cameraInfoInternal = (CameraInfoInternal)this.mCameraInfo;
                return cameraInfoInternal.getSupportedOutputFormats().contains(4101);
            }
            return false;
        }

        private boolean isRawSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                CameraInfoInternal cameraInfoInternal = (CameraInfoInternal)this.mCameraInfo;
                if (!cameraInfoInternal.getAvailableCapabilities().contains(3)) {
                    return false;
                }
                return cameraInfoInternal.getSupportedOutputFormats().contains(32);
            }
            return false;
        }

        private @Nullable Set<Integer> getSupportedOutputFormatsFromAdapterCameraInfo() {
            if (!(this.mCameraInfo instanceof AdapterCameraInfo)) {
                return null;
            }
            CameraConfig cameraConfig = ((AdapterCameraInfo)this.mCameraInfo).getCameraConfig();
            UseCaseConfigFactory useCaseConfigFactory = cameraConfig.getUseCaseConfigFactory();
            Config useCaseConfig = useCaseConfigFactory.getConfig(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE, 1);
            if (useCaseConfig == null || !useCaseConfig.containsOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS)) {
                return null;
            }
            HashSet<Integer> formats = new HashSet<Integer>();
            formats.add(0);
            for (Pair formatSizesPair : (List)useCaseConfig.retrieveOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS)) {
                if ((Integer)formatSizesPair.first != 4101) continue;
                formats.add(1);
                break;
            }
            return formats;
        }
    }

    public static final class Metadata {
        private boolean mIsReversedHorizontal;
        private boolean mIsReversedHorizontalSet = false;
        private boolean mIsReversedVertical;
        private @Nullable Location mLocation;

        public boolean isReversedHorizontal() {
            return this.mIsReversedHorizontal;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isReversedHorizontalSet() {
            return this.mIsReversedHorizontalSet;
        }

        public void setReversedHorizontal(boolean isReversedHorizontal) {
            this.mIsReversedHorizontal = isReversedHorizontal;
            this.mIsReversedHorizontalSet = true;
        }

        public boolean isReversedVertical() {
            return this.mIsReversedVertical;
        }

        public void setReversedVertical(boolean isReversedVertical) {
            this.mIsReversedVertical = isReversedVertical;
        }

        public @Nullable Location getLocation() {
            return this.mLocation;
        }

        public void setLocation(@Nullable Location location) {
            this.mLocation = location;
        }

        public @NonNull String toString() {
            return "Metadata{mIsReversedHorizontal=" + this.mIsReversedHorizontal + ", mIsReversedVertical=" + this.mIsReversedVertical + ", mLocation=" + this.mLocation + "}";
        }
    }

    public static class OutputFileResults {
        private final @Nullable Uri mSavedUri;
        private final int mImageFormat;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputFileResults(@Nullable Uri savedUri) {
            this(savedUri, 256);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputFileResults(@Nullable Uri savedUri, int imageFormat) {
            this.mSavedUri = savedUri;
            this.mImageFormat = imageFormat;
        }

        public @Nullable Uri getSavedUri() {
            return this.mSavedUri;
        }

        public int getImageFormat() {
            return this.mImageFormat;
        }
    }

    public static interface ScreenFlashListener {
        public void onCompleted();
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface OutputFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImageCaptureError {
    }
}

