/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ImageAnalysisNonBlockingAnalyzer
extends ImageAnalysisAbstractAnalyzer {
    final Executor mBackgroundExecutor;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @VisibleForTesting
    @Nullable ImageProxy mCachedImage;
    @GuardedBy(value="mLock")
    private @Nullable CacheAnalyzingImageProxy mPostedImage;

    ImageAnalysisNonBlockingAnalyzer(Executor executor) {
        this.mBackgroundExecutor = executor;
    }

    @Override
    @Nullable ImageProxy acquireImage(@NonNull ImageReaderProxy imageReaderProxy) {
        return imageReaderProxy.acquireLatestImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onValidImageAvailable(@NonNull ImageProxy imageProxy) {
        Object object = this.mLock;
        synchronized (object) {
            CacheAnalyzingImageProxy newPostedImage;
            if (!this.mIsAttached) {
                imageProxy.close();
                return;
            }
            if (this.mPostedImage != null) {
                if (imageProxy.getImageInfo().getTimestamp() <= this.mPostedImage.getImageInfo().getTimestamp()) {
                    imageProxy.close();
                } else {
                    if (this.mCachedImage != null) {
                        this.mCachedImage.close();
                    }
                    this.mCachedImage = imageProxy;
                }
                return;
            }
            this.mPostedImage = newPostedImage = new CacheAnalyzingImageProxy(imageProxy, this);
            Futures.addCallback(this.analyzeImage(newPostedImage), new FutureCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                }

                @Override
                public void onFailure(@NonNull Throwable t) {
                    newPostedImage.close();
                }
            }, CameraXExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearCache() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCachedImage != null) {
                this.mCachedImage.close();
                this.mCachedImage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyzeCachedImage() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPostedImage = null;
            if (this.mCachedImage != null) {
                ImageProxy cachedImage = this.mCachedImage;
                this.mCachedImage = null;
                this.onValidImageAvailable(cachedImage);
            }
        }
    }

    static class CacheAnalyzingImageProxy
    extends ForwardingImageProxy {
        final WeakReference<ImageAnalysisNonBlockingAnalyzer> mNonBlockingAnalyzerWeakReference;

        CacheAnalyzingImageProxy(@NonNull ImageProxy image, @NonNull ImageAnalysisNonBlockingAnalyzer nonBlockingAnalyzer) {
            super(image);
            this.mNonBlockingAnalyzerWeakReference = new WeakReference<ImageAnalysisNonBlockingAnalyzer>(nonBlockingAnalyzer);
            this.addOnImageCloseListener(imageProxy -> {
                ImageAnalysisNonBlockingAnalyzer analyzer = (ImageAnalysisNonBlockingAnalyzer)this.mNonBlockingAnalyzerWeakReference.get();
                if (analyzer != null) {
                    analyzer.mBackgroundExecutor.execute(() -> analyzer.analyzeCachedImage());
                }
            });
        }
    }
}

