/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ImageWriter;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProcessingUtil;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.compat.ImageWriterCompat;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.os.OperationCanceledException;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

abstract class ImageAnalysisAbstractAnalyzer
implements ImageReaderProxy.OnImageAvailableListener {
    private static final String TAG = "ImageAnalysisAnalyzer";
    @GuardedBy(value="mAnalyzerLock")
    private ImageAnalysis.Analyzer mSubscribedAnalyzer;
    @IntRange(from=0L, to=359L)
    private volatile int mRelativeRotation;
    @IntRange(from=0L, to=359L)
    private volatile int mPrevBufferRotationDegrees;
    private volatile int mOutputImageFormat = 1;
    private volatile boolean mOutputImageRotationEnabled;
    private volatile boolean mOnePixelShiftEnabled;
    @GuardedBy(value="mAnalyzerLock")
    private Executor mUserExecutor;
    @GuardedBy(value="mAnalyzerLock")
    private @Nullable SafeCloseImageReaderProxy mProcessedImageReaderProxy;
    @GuardedBy(value="mAnalyzerLock")
    private @Nullable ImageWriter mProcessedImageWriter;
    @GuardedBy(value="mAnalyzerLock")
    private Rect mOriginalViewPortCropRect = new Rect();
    @GuardedBy(value="mAnalyzerLock")
    private Rect mUpdatedViewPortCropRect = new Rect();
    @GuardedBy(value="mAnalyzerLock")
    private Matrix mOriginalSensorToBufferTransformMatrix = new Matrix();
    @GuardedBy(value="mAnalyzerLock")
    private Matrix mUpdatedSensorToBufferTransformMatrix = new Matrix();
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mRGBConvertedBuffer;
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mYRotatedBuffer;
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mURotatedBuffer;
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mVRotatedBuffer;
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mNV21YDelegatedBuffer;
    @GuardedBy(value="mAnalyzerLock")
    @VisibleForTesting
    @Nullable ByteBuffer mNV21UVDelegatedBuffer;
    private final Object mAnalyzerLock = new Object();
    protected boolean mIsAttached = true;

    ImageAnalysisAbstractAnalyzer() {
    }

    @Override
    public void onImageAvailable(@NonNull ImageReaderProxy imageReaderProxy) {
        try {
            ImageProxy imageProxy = this.acquireImage(imageReaderProxy);
            if (imageProxy != null) {
                this.onValidImageAvailable(imageProxy);
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "Failed to acquire image.", e);
        }
    }

    abstract @Nullable ImageProxy acquireImage(@NonNull ImageReaderProxy var1);

    abstract void onValidImageAvailable(@NonNull ImageProxy var1);

    abstract void clearCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> analyzeImage(@NonNull ImageProxy imageProxy) {
        ListenableFuture future;
        ByteBuffer nv21UVDelegatedBuffer;
        ByteBuffer nv21YDelegatedBuffer;
        ByteBuffer vRotatedBuffer;
        ByteBuffer uRotatedBuffer;
        ByteBuffer yRotatedBuffer;
        ByteBuffer rgbConvertedBuffer;
        ImageWriter processedImageWriter;
        SafeCloseImageReaderProxy processedImageReaderProxy;
        boolean outputImageDirty;
        ImageAnalysis.Analyzer analyzer;
        Executor executor;
        int currentBufferRotationDegrees = this.mOutputImageRotationEnabled ? this.mRelativeRotation : 0;
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            executor = this.mUserExecutor;
            analyzer = this.mSubscribedAnalyzer;
            boolean bl = outputImageDirty = this.mOutputImageRotationEnabled && currentBufferRotationDegrees != this.mPrevBufferRotationDegrees;
            if (outputImageDirty) {
                this.recreateImageReaderProxy(imageProxy, currentBufferRotationDegrees);
            }
            if (this.mOutputImageRotationEnabled || this.mOutputImageFormat == 3) {
                this.createHelperBuffer(imageProxy);
            }
            processedImageReaderProxy = this.mProcessedImageReaderProxy;
            processedImageWriter = this.mProcessedImageWriter;
            rgbConvertedBuffer = this.mRGBConvertedBuffer;
            yRotatedBuffer = this.mYRotatedBuffer;
            uRotatedBuffer = this.mURotatedBuffer;
            vRotatedBuffer = this.mVRotatedBuffer;
            nv21YDelegatedBuffer = this.mNV21YDelegatedBuffer;
            nv21UVDelegatedBuffer = this.mNV21UVDelegatedBuffer;
        }
        if (analyzer != null && executor != null && this.mIsAttached) {
            ImageProxy processedImageProxy = null;
            if (processedImageReaderProxy != null) {
                if (this.mOutputImageFormat == 2) {
                    processedImageProxy = ImageProcessingUtil.convertYUVToRGB(imageProxy, processedImageReaderProxy, rgbConvertedBuffer, currentBufferRotationDegrees, this.mOnePixelShiftEnabled);
                } else if (this.mOutputImageFormat == 1) {
                    if (this.mOnePixelShiftEnabled) {
                        ImageProcessingUtil.applyPixelShiftForYUV(imageProxy);
                    }
                    if (processedImageWriter != null && yRotatedBuffer != null && uRotatedBuffer != null && vRotatedBuffer != null) {
                        processedImageProxy = ImageProcessingUtil.rotateYUV(imageProxy, processedImageReaderProxy, processedImageWriter, yRotatedBuffer, uRotatedBuffer, vRotatedBuffer, currentBufferRotationDegrees);
                    }
                }
            } else if (this.mOutputImageFormat == 3) {
                if (this.mOnePixelShiftEnabled) {
                    ImageProcessingUtil.applyPixelShiftForYUV(imageProxy);
                }
                if (yRotatedBuffer != null && uRotatedBuffer != null && vRotatedBuffer != null && nv21YDelegatedBuffer != null && nv21UVDelegatedBuffer != null) {
                    processedImageProxy = ImageProcessingUtil.rotateYUVAndConvertToNV21(imageProxy, yRotatedBuffer, uRotatedBuffer, vRotatedBuffer, nv21YDelegatedBuffer, nv21UVDelegatedBuffer, currentBufferRotationDegrees);
                }
            }
            boolean outputProcessedImageFailed = processedImageProxy == null;
            ImageProxy outputImageProxy = outputProcessedImageFailed ? imageProxy : processedImageProxy;
            Rect cropRect = new Rect();
            Matrix transformMatrix = new Matrix();
            Object object2 = this.mAnalyzerLock;
            synchronized (object2) {
                if (outputImageDirty && !outputProcessedImageFailed) {
                    this.recalculateTransformMatrixAndCropRect(imageProxy.getWidth(), imageProxy.getHeight(), outputImageProxy.getWidth(), outputImageProxy.getHeight());
                }
                this.mPrevBufferRotationDegrees = currentBufferRotationDegrees;
                cropRect.set(this.mUpdatedViewPortCropRect);
                transformMatrix.set(this.mUpdatedSensorToBufferTransformMatrix);
            }
            future = CallbackToFutureAdapter.getFuture(completer -> {
                executor.execute(() -> {
                    if (this.mIsAttached) {
                        ImageInfo imageInfo = ImmutableImageInfo.create(imageProxy.getImageInfo().getTagBundle(), imageProxy.getImageInfo().getTimestamp(), this.mOutputImageRotationEnabled ? 0 : this.mRelativeRotation, transformMatrix, imageProxy.getImageInfo().getFlashState());
                        SettableImageProxy outputSettableImageProxy = new SettableImageProxy(outputImageProxy, imageInfo);
                        if (!cropRect.isEmpty()) {
                            outputSettableImageProxy.setCropRect(cropRect);
                        }
                        analyzer.analyze(outputSettableImageProxy);
                        completer.set(null);
                    } else {
                        completer.setException((Throwable)new OperationCanceledException("ImageAnalysis is detached"));
                    }
                });
                return "analyzeImage";
            });
        } else {
            future = Futures.immediateFailedFuture((Throwable)new OperationCanceledException("No analyzer or executor currently set."));
        }
        return future;
    }

    private static @NonNull SafeCloseImageReaderProxy createImageReaderProxy(int imageWidth, int imageHeight, int rotation, int format, int maxImages) {
        boolean flipWH = rotation == 90 || rotation == 270;
        int width = flipWH ? imageHeight : imageWidth;
        int height = flipWH ? imageWidth : imageHeight;
        return new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(width, height, format, maxImages));
    }

    void setRelativeRotation(int relativeRotation) {
        this.mRelativeRotation = relativeRotation;
    }

    void setOutputImageRotationEnabled(boolean outputImageRotationEnabled) {
        this.mOutputImageRotationEnabled = outputImageRotationEnabled;
    }

    void setOutputImageFormat(int outputImageFormat) {
        this.mOutputImageFormat = outputImageFormat;
    }

    void setOnePixelShiftEnabled(boolean onePixelShiftEnabled) {
        this.mOnePixelShiftEnabled = onePixelShiftEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            this.mOriginalViewPortCropRect = viewPortCropRect;
            this.mUpdatedViewPortCropRect = new Rect(this.mOriginalViewPortCropRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSensorToBufferTransformMatrix(@NonNull Matrix sensorToBufferTransformMatrix) {
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            this.mOriginalSensorToBufferTransformMatrix = sensorToBufferTransformMatrix;
            this.mUpdatedSensorToBufferTransformMatrix = new Matrix(this.mOriginalSensorToBufferTransformMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProcessedImageReaderProxy(@NonNull SafeCloseImageReaderProxy processedImageReaderProxy) {
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            this.mProcessedImageReaderProxy = processedImageReaderProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnalyzer(@Nullable Executor userExecutor, @Nullable ImageAnalysis.Analyzer subscribedAnalyzer) {
        if (subscribedAnalyzer == null) {
            this.clearCache();
        }
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            this.mSubscribedAnalyzer = subscribedAnalyzer;
            this.mUserExecutor = userExecutor;
        }
    }

    void attach() {
        this.mIsAttached = true;
    }

    void detach() {
        this.mIsAttached = false;
        this.clearCache();
    }

    @GuardedBy(value="mAnalyzerLock")
    private void createHelperBuffer(@NonNull ImageProxy imageProxy) {
        if (this.mOutputImageFormat == 1 || this.mOutputImageFormat == 3) {
            if (this.mYRotatedBuffer == null) {
                this.mYRotatedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight());
            }
            this.mYRotatedBuffer.position(0);
            if (this.mURotatedBuffer == null) {
                this.mURotatedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight() / 4);
            }
            this.mURotatedBuffer.position(0);
            if (this.mVRotatedBuffer == null) {
                this.mVRotatedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight() / 4);
            }
            this.mVRotatedBuffer.position(0);
            if (this.mOutputImageFormat == 3) {
                if (this.mNV21YDelegatedBuffer == null) {
                    this.mNV21YDelegatedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight());
                }
                this.mNV21YDelegatedBuffer.position(0);
                if (this.mNV21UVDelegatedBuffer == null) {
                    this.mNV21UVDelegatedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight() / 2);
                }
                this.mNV21UVDelegatedBuffer.position(0);
            }
        } else if (this.mOutputImageFormat == 2 && this.mRGBConvertedBuffer == null) {
            this.mRGBConvertedBuffer = ByteBuffer.allocateDirect(imageProxy.getWidth() * imageProxy.getHeight() * 4);
        }
    }

    @GuardedBy(value="mAnalyzerLock")
    private void recreateImageReaderProxy(@NonNull ImageProxy imageProxy, @IntRange(from=0L, to=359L) int relativeRotation) {
        if (this.mProcessedImageReaderProxy == null) {
            return;
        }
        this.mProcessedImageReaderProxy.safeClose();
        this.mProcessedImageReaderProxy = ImageAnalysisAbstractAnalyzer.createImageReaderProxy(imageProxy.getWidth(), imageProxy.getHeight(), relativeRotation, this.mProcessedImageReaderProxy.getImageFormat(), this.mProcessedImageReaderProxy.getMaxImages());
        if (Build.VERSION.SDK_INT >= 23 && this.mOutputImageFormat == 1) {
            if (this.mProcessedImageWriter != null) {
                ImageWriterCompat.close(this.mProcessedImageWriter);
            }
            this.mProcessedImageWriter = ImageWriterCompat.newInstance(this.mProcessedImageReaderProxy.getSurface(), this.mProcessedImageReaderProxy.getMaxImages());
        }
    }

    @GuardedBy(value="mAnalyzerLock")
    private void recalculateTransformMatrixAndCropRect(int originalWidth, int originalHeight, int rotatedWidth, int rotatedHeight) {
        Matrix additionalTransformMatrix = ImageAnalysisAbstractAnalyzer.getAdditionalTransformMatrixAppliedByProcessor(originalWidth, originalHeight, rotatedWidth, rotatedHeight, this.mRelativeRotation);
        this.mUpdatedViewPortCropRect = ImageAnalysisAbstractAnalyzer.getUpdatedCropRect(this.mOriginalViewPortCropRect, additionalTransformMatrix);
        this.mUpdatedSensorToBufferTransformMatrix.setConcat(this.mOriginalSensorToBufferTransformMatrix, additionalTransformMatrix);
    }

    static @NonNull Rect getUpdatedCropRect(@NonNull Rect originalCropRect, @NonNull Matrix additionalTransformMatrix) {
        RectF rectF = new RectF(originalCropRect);
        additionalTransformMatrix.mapRect(rectF);
        Rect rect = new Rect();
        rectF.round(rect);
        return rect;
    }

    @VisibleForTesting
    static @NonNull Matrix getAdditionalTransformMatrixAppliedByProcessor(int originalWidth, int originalHeight, int rotatedWidth, int rotatedHeight, @IntRange(from=0L, to=359L) int relativeRotation) {
        Matrix matrix = new Matrix();
        if (relativeRotation > 0) {
            matrix.setRectToRect(new RectF(0.0f, 0.0f, (float)originalWidth, (float)originalHeight), TransformUtils.NORMALIZED_RECT, Matrix.ScaleToFit.FILL);
            matrix.postRotate((float)relativeRotation);
            matrix.postConcat(TransformUtils.getNormalizedToBuffer(new RectF(0.0f, 0.0f, (float)rotatedWidth, (float)rotatedHeight)));
        }
        return matrix;
    }
}

