/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalUseCaseApi;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageAnalysisBlockingAnalyzer;
import androidx.camera.core.ImageAnalysisNonBlockingAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.Logger;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageAnalysisConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.StreamUseCase;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.compat.quirk.OnePixelShiftQuirk;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ImageAnalysis
extends UseCase {
    public static final int STRATEGY_KEEP_ONLY_LATEST = 0;
    public static final int STRATEGY_BLOCK_PRODUCER = 1;
    public static final int OUTPUT_IMAGE_FORMAT_YUV_420_888 = 1;
    public static final int OUTPUT_IMAGE_FORMAT_RGBA_8888 = 2;
    public static final int OUTPUT_IMAGE_FORMAT_NV21 = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageAnalysis";
    private static final int NON_BLOCKING_IMAGE_DEPTH = 4;
    private static final int DEFAULT_BACKPRESSURE_STRATEGY = 0;
    private static final int DEFAULT_IMAGE_QUEUE_DEPTH = 6;
    private static final int DEFAULT_OUTPUT_IMAGE_FORMAT = 1;
    private static final Boolean DEFAULT_ONE_PIXEL_SHIFT_ENABLED = null;
    private static final boolean DEFAULT_OUTPUT_IMAGE_ROTATION_ENABLED = false;
    private final Object mAnalysisLock = new Object();
    @GuardedBy(value="mAnalysisLock")
    ImageAnalysisAbstractAnalyzer mImageAnalysisAbstractAnalyzer;
    @GuardedBy(value="mAnalysisLock")
    private Executor mSubscribedAnalyzerExecutor;
    @GuardedBy(value="mAnalysisLock")
    private Analyzer mSubscribedAnalyzer;
    @GuardedBy(value="mAnalysisLock")
    private Rect mViewPortCropRect;
    @GuardedBy(value="mAnalysisLock")
    private Matrix mSensorToBufferTransformMatrix;
    SessionConfig.Builder mSessionConfigBuilder;
    private @Nullable DeferrableSurface mDeferrableSurface;
    private @Nullable SessionConfig.CloseableErrorListener mCloseableErrorListener;
    public static final int COORDINATE_SYSTEM_ORIGINAL = 0;
    public static final int COORDINATE_SYSTEM_VIEW_REFERENCED = 1;
    public static final int COORDINATE_SYSTEM_SENSOR = 2;

    ImageAnalysis(@NonNull ImageAnalysisConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        Size analyzerResolution;
        Object object = this.mAnalysisLock;
        synchronized (object) {
            analyzerResolution = this.mSubscribedAnalyzer != null ? this.mSubscribedAnalyzer.getDefaultTargetResolution() : null;
        }
        if (analyzerResolution == null) {
            return builder.getUseCaseConfig();
        }
        int targetRotation = builder.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_ROTATION, 0);
        if (cameraInfo.getSensorRotationDegrees(targetRotation) % 180 == 90) {
            analyzerResolution = new Size(analyzerResolution.getHeight(), analyzerResolution.getWidth());
        }
        if (!builder.getUseCaseConfig().containsOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION)) {
            builder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, analyzerResolution);
        }
        if (builder.getUseCaseConfig().containsOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR)) {
            ResolutionSelector.Builder resolutionSelectorBuilder;
            ResolutionSelector appResolutionSelector = this.getAppConfig().retrieveOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, null);
            ResolutionSelector.Builder builder2 = resolutionSelectorBuilder = appResolutionSelector == null ? new ResolutionSelector.Builder() : ResolutionSelector.Builder.fromResolutionSelector(appResolutionSelector);
            if (appResolutionSelector == null || appResolutionSelector.getResolutionStrategy() == null) {
                resolutionSelectorBuilder.setResolutionStrategy(new ResolutionStrategy(analyzerResolution, 1));
            }
            if (appResolutionSelector == null) {
                Size analyzerResolutionFinal = analyzerResolution;
                resolutionSelectorBuilder.setResolutionFilter((supportedSizes, rotationDegrees) -> {
                    ArrayList<Size> resultList = new ArrayList<Size>(supportedSizes);
                    if (resultList.contains(analyzerResolutionFinal)) {
                        resultList.remove(analyzerResolutionFinal);
                        resultList.add(0, analyzerResolutionFinal);
                    }
                    return resultList;
                });
            }
            builder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, resolutionSelectorBuilder.build());
        }
        return builder.getUseCaseConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageAnalysisConfig config, @NonNull StreamSpec streamSpec) {
        SafeCloseImageReaderProxy processedImageReaderProxy;
        ImageAnalysisAbstractAnalyzer imageAnalysisAbstractAnalyzer;
        Threads.checkMainThread();
        Size resolution = streamSpec.getResolution();
        Executor backgroundExecutor = (Executor)Preconditions.checkNotNull((Object)config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor()));
        int imageQueueDepth = this.getBackpressureStrategy() == 1 ? this.getImageQueueDepth() : 4;
        SafeCloseImageReaderProxy imageReaderProxy = config.getImageReaderProxyProvider() != null ? new SafeCloseImageReaderProxy(config.getImageReaderProxyProvider().newInstance(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), imageQueueDepth, 0L)) : new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), imageQueueDepth));
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.recreateImageAnalysisAbstractAnalyzer();
            imageAnalysisAbstractAnalyzer = this.mImageAnalysisAbstractAnalyzer;
        }
        boolean flipWH = this.getCamera() != null ? this.isFlipWH(this.getCamera()) : false;
        int width = flipWH ? resolution.getHeight() : resolution.getWidth();
        int height = flipWH ? resolution.getWidth() : resolution.getHeight();
        int format = this.getOutputImageFormat() == 2 ? 1 : 35;
        boolean isYuv2Rgb = this.getImageFormat() == 35 && this.getOutputImageFormat() == 2;
        boolean isYuv2Nv21 = this.getImageFormat() == 35 && this.getOutputImageFormat() == 3;
        boolean isYuvRotationOrPixelShift = this.getImageFormat() == 35 && (this.getCamera() != null && this.getRelativeRotation(this.getCamera()) != 0 || Boolean.TRUE.equals(this.getOnePixelShiftEnabled()));
        SafeCloseImageReaderProxy safeCloseImageReaderProxy = processedImageReaderProxy = isYuv2Rgb || isYuvRotationOrPixelShift && !isYuv2Nv21 ? new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(width, height, format, imageReaderProxy.getMaxImages())) : null;
        if (processedImageReaderProxy != null) {
            imageAnalysisAbstractAnalyzer.setProcessedImageReaderProxy(processedImageReaderProxy);
        }
        this.tryUpdateRelativeRotation();
        imageReaderProxy.setOnImageAvailableListener(imageAnalysisAbstractAnalyzer, backgroundExecutor);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config, streamSpec.getResolution());
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(imageReaderProxy.getSurface(), resolution, this.getImageFormat());
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
            imageReaderProxy.safeClose();
            if (processedImageReaderProxy != null) {
                processedImageReaderProxy.safeClose();
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.setSessionType(streamSpec.getSessionType());
        this.applyExpectedFrameRateRange(sessionConfigBuilder, streamSpec);
        sessionConfigBuilder.addSurface(this.mDeferrableSurface, streamSpec.getDynamicRange(), null, -1);
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
        }
        this.mCloseableErrorListener = new SessionConfig.CloseableErrorListener((sessionConfig, error) -> {
            if (this.getCamera() == null) {
                return;
            }
            this.clearPipeline();
            imageAnalysisAbstractAnalyzer.clearCache();
            this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageAnalysisConfig)this.getCurrentConfig(), (StreamSpec)Preconditions.checkNotNull((Object)this.getAttachedStreamSpec()));
            this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
            this.notifyReset();
        });
        sessionConfigBuilder.setErrorListener(this.mCloseableErrorListener);
        return sessionConfigBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateImageAnalysisAbstractAnalyzer() {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            ImageAnalysisConfig config = (ImageAnalysisConfig)this.getCurrentConfig();
            this.mImageAnalysisAbstractAnalyzer = config.getBackpressureStrategy(0) == 1 ? new ImageAnalysisBlockingAnalyzer() : new ImageAnalysisNonBlockingAnalyzer(config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor()));
            this.mImageAnalysisAbstractAnalyzer.setOutputImageFormat(this.getOutputImageFormat());
            this.mImageAnalysisAbstractAnalyzer.setOutputImageRotationEnabled(this.isOutputImageRotationEnabled());
            CameraInternal cameraInternal = this.getCamera();
            Boolean isOnePixelShiftEnabled = this.getOnePixelShiftEnabled();
            boolean isOnePixelShiftIssueDevice = false;
            if (cameraInternal != null) {
                isOnePixelShiftIssueDevice = cameraInternal.getCameraInfoInternal().getCameraQuirks().contains(OnePixelShiftQuirk.class);
            }
            this.mImageAnalysisAbstractAnalyzer.setOnePixelShiftEnabled(isOnePixelShiftEnabled == null ? isOnePixelShiftIssueDevice : isOnePixelShiftEnabled);
            if (cameraInternal != null) {
                this.mImageAnalysisAbstractAnalyzer.setRelativeRotation(this.getRelativeRotation(cameraInternal));
            }
            if (this.mViewPortCropRect != null) {
                this.mImageAnalysisAbstractAnalyzer.setViewPortCropRect(this.mViewPortCropRect);
            }
            if (this.mSensorToBufferTransformMatrix != null) {
                this.mImageAnalysisAbstractAnalyzer.setSensorToBufferTransformMatrix(this.mSensorToBufferTransformMatrix);
            }
            if (this.mSubscribedAnalyzerExecutor != null && this.mSubscribedAnalyzer != null) {
                this.mImageAnalysisAbstractAnalyzer.setAnalyzer(this.mSubscribedAnalyzerExecutor, this.mSubscribedAnalyzer);
            }
        }
    }

    void clearPipeline() {
        Threads.checkMainThread();
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
            this.mCloseableErrorListener = null;
        }
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
            this.mDeferrableSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnalyzer() {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            if (this.mImageAnalysisAbstractAnalyzer != null) {
                this.mImageAnalysisAbstractAnalyzer.setAnalyzer(null, null);
            }
            if (this.mSubscribedAnalyzer != null) {
                this.notifyInactive();
            }
            this.mSubscribedAnalyzerExecutor = null;
            this.mSubscribedAnalyzer = null;
        }
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        if (this.setTargetRotationInternal(rotation)) {
            this.tryUpdateRelativeRotation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnalyzer(@NonNull Executor executor, @NonNull Analyzer analyzer) {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            if (this.mImageAnalysisAbstractAnalyzer != null) {
                this.mImageAnalysisAbstractAnalyzer.setAnalyzer(executor, image -> analyzer.analyze(image));
            }
            if (this.mSubscribedAnalyzer == null) {
                this.notifyActive();
            }
            this.mSubscribedAnalyzerExecutor = executor;
            this.mSubscribedAnalyzer = analyzer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        Object object = this.mAnalysisLock;
        synchronized (object) {
            if (this.mImageAnalysisAbstractAnalyzer != null) {
                this.mImageAnalysisAbstractAnalyzer.setViewPortCropRect(viewPortCropRect);
            }
            this.mViewPortCropRect = viewPortCropRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSensorToBufferTransformMatrix(@NonNull Matrix matrix) {
        super.setSensorToBufferTransformMatrix(matrix);
        Object object = this.mAnalysisLock;
        synchronized (object) {
            if (this.mImageAnalysisAbstractAnalyzer != null) {
                this.mImageAnalysisAbstractAnalyzer.setSensorToBufferTransformMatrix(matrix);
            }
            this.mSensorToBufferTransformMatrix = matrix;
        }
    }

    private boolean isFlipWH(@NonNull CameraInternal cameraInternal) {
        return this.isOutputImageRotationEnabled() ? this.getRelativeRotation(cameraInternal) % 180 != 0 : false;
    }

    public int getBackpressureStrategy() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getBackpressureStrategy(0);
    }

    @ExperimentalUseCaseApi
    public @Nullable Executor getBackgroundExecutor() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getBackgroundExecutor(null);
    }

    public int getImageQueueDepth() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getImageQueueDepth(6);
    }

    public int getOutputImageFormat() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getOutputImageFormat(1);
    }

    public boolean isOutputImageRotationEnabled() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).isOutputImageRotationEnabled(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable Boolean getOnePixelShiftEnabled() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getOnePixelShiftEnabled(DEFAULT_ONE_PIXEL_SHIFT_ENABLED);
    }

    public @Nullable ResolutionInfo getResolutionInfo() {
        return this.getResolutionInfoInternal();
    }

    public @Nullable ResolutionSelector getResolutionSelector() {
        return ((ImageOutputConfig)((Object)this.getCurrentConfig())).getResolutionSelector(null);
    }

    public @NonNull String toString() {
        return "ImageAnalysis:" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onUnbind() {
        this.clearPipeline();
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.mImageAnalysisAbstractAnalyzer.detach();
            this.mImageAnalysisAbstractAnalyzer = null;
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        Logger.d(TAG, "onSuggestedStreamSpecUpdated: primaryStreamSpec = " + primaryStreamSpec + ", secondaryStreamSpec " + secondaryStreamSpec);
        ImageAnalysisConfig config = (ImageAnalysisConfig)this.getCurrentConfig();
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), config, primaryStreamSpec);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        return primaryStreamSpec;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUpdateRelativeRotation() {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            CameraInternal cameraInternal = this.getCamera();
            if (cameraInternal != null) {
                this.mImageAnalysisAbstractAnalyzer.setRelativeRotation(this.getRelativeRotation(cameraInternal));
            }
        }
    }

    public static interface Analyzer {
        public void analyze(@NonNull ImageProxy var1);

        default public @Nullable Size getDefaultTargetResolution() {
            return null;
        }

        default public int getTargetCoordinateSystem() {
            return 0;
        }

        default public void updateTransform(@Nullable Matrix matrix) {
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageAnalysisConfig> {
        private static final Size DEFAULT_TARGET_RESOLUTION = new Size(640, 480);
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 1;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final DynamicRange DEFAULT_DYNAMIC_RANGE = DynamicRange.SDR;
        private static final ResolutionSelector DEFAULT_RESOLUTION_SELECTOR = new ResolutionSelector.Builder().setAspectRatioStrategy(AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY).setResolutionStrategy(new ResolutionStrategy(SizeUtil.RESOLUTION_VGA, 1)).build();
        private static final ImageAnalysisConfig DEFAULT_CONFIG;

        @Override
        public @NonNull ImageAnalysisConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setDefaultResolution(DEFAULT_TARGET_RESOLUTION).setSurfaceOccupancyPriority(1).setTargetAspectRatio(0).setResolutionSelector(DEFAULT_RESOLUTION_SELECTOR).setDynamicRange(DEFAULT_DYNAMIC_RANGE);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static final class Builder
    implements ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder>,
    UseCaseConfig.Builder<ImageAnalysis, ImageAnalysisConfig, Builder>,
    ImageInputConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageAnalysis.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setCaptureType(UseCaseConfigFactory.CaptureType.IMAGE_ANALYSIS);
            this.setTargetClass((Class)ImageAnalysis.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        static @NonNull Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @NonNull Builder fromConfig(@NonNull ImageAnalysisConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        public @NonNull Builder setBackpressureStrategy(int strategy) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_BACKPRESSURE_STRATEGY, strategy);
            return this;
        }

        public @NonNull Builder setImageQueueDepth(int depth) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_IMAGE_QUEUE_DEPTH, depth);
            return this;
        }

        public @NonNull Builder setOutputImageFormat(int outputImageFormat) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_OUTPUT_IMAGE_FORMAT, outputImageFormat);
            return this;
        }

        @RequiresApi(value=23)
        public @NonNull Builder setOutputImageRotationEnabled(boolean outputImageRotationEnabled) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_OUTPUT_IMAGE_ROTATION_ENABLED, outputImageRotationEnabled);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setOnePixelShiftEnabled(boolean onePixelShiftEnabled) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_ONE_PIXEL_SHIFT_ENABLED, onePixelShiftEnabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull ImageAnalysisConfig getUseCaseConfig() {
            return new ImageAnalysisConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        public @NonNull ImageAnalysis build() {
            ImageAnalysisConfig imageAnalysisConfig = this.getUseCaseConfig();
            ImageOutputConfig.validateConfig(imageAnalysisConfig);
            return new ImageAnalysis(imageAnalysisConfig);
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setTargetClass(@NonNull Class<ImageAnalysis> targetClass) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(UseCaseConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        public @NonNull Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @Deprecated
        public @NonNull Builder setTargetAspectRatio(int aspectRatio) {
            if (aspectRatio == -1) {
                aspectRatio = 0;
            }
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        public @NonNull Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setMirrorMode(int mirrorMode) {
            throw new UnsupportedOperationException("setMirrorMode is not supported.");
        }

        @Override
        @Deprecated
        public @NonNull Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        public @NonNull Builder setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        @Override
        public @NonNull Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, captureType);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setStreamUseCase(@NonNull StreamUseCase streamUseCase) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_STREAM_USE_CASE, streamUseCase);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public @NonNull Builder setDynamicRange(@NonNull DynamicRange dynamicRange) {
            if (!Objects.equals(DynamicRange.SDR, dynamicRange)) {
                throw new UnsupportedOperationException("ImageAnalysis currently only supports SDR");
            }
            this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, dynamicRange);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface OutputImageFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BackpressureStrategy {
    }
}

