/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.FloatRange;
import androidx.core.util.Pair;
import org.jspecify.annotations.NonNull;

public class CompositionSettings {
    public static final CompositionSettings DEFAULT = new Builder().setAlpha(1.0f).setOffset(0.0f, 0.0f).setScale(1.0f, 1.0f).build();
    private final float mAlpha;
    private final Pair<Float, Float> mOffset;
    private final Pair<Float, Float> mScale;

    private CompositionSettings(float alpha, Pair<Float, Float> offset, Pair<Float, Float> scale) {
        this.mAlpha = alpha;
        this.mOffset = offset;
        this.mScale = scale;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public @NonNull Pair<Float, Float> getOffset() {
        return this.mOffset;
    }

    public @NonNull Pair<Float, Float> getScale() {
        return this.mScale;
    }

    public static final class Builder {
        private float mAlpha = 1.0f;
        private Pair<Float, Float> mOffset = Pair.create((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        private Pair<Float, Float> mScale = Pair.create((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));

        public @NonNull Builder setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.mAlpha = alpha;
            return this;
        }

        public @NonNull Builder setOffset(@FloatRange(from=-1.0, to=1.0) float offsetX, @FloatRange(from=-1.0, to=1.0) float offsetY) {
            this.mOffset = Pair.create((Object)Float.valueOf(offsetX), (Object)Float.valueOf(offsetY));
            return this;
        }

        public @NonNull Builder setScale(float scaleX, float scaleY) {
            this.mScale = Pair.create((Object)Float.valueOf(scaleX), (Object)Float.valueOf(scaleY));
            return this;
        }

        public @NonNull CompositionSettings build() {
            return new CompositionSettings(this.mAlpha, this.mOffset, this.mScale);
        }
    }
}

