/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CaptureBundles {
    public static @NonNull CaptureBundle singleDefaultCaptureBundle() {
        return CaptureBundles.createCaptureBundle(new CaptureStage.DefaultCaptureStage());
    }

    static @NonNull CaptureBundle createCaptureBundle(CaptureStage ... captureStages) {
        return new CaptureBundleImpl(Arrays.asList(captureStages));
    }

    static @NonNull CaptureBundle createCaptureBundle(@NonNull List<CaptureStage> captureStageList) {
        return new CaptureBundleImpl(captureStageList);
    }

    private CaptureBundles() {
    }

    static final class CaptureBundleImpl
    implements CaptureBundle {
        final List<CaptureStage> mCaptureStageList;

        CaptureBundleImpl(List<CaptureStage> captureStageList) {
            if (captureStageList == null || captureStageList.isEmpty()) {
                throw new IllegalArgumentException("Cannot set an empty CaptureStage list.");
            }
            this.mCaptureStageList = Collections.unmodifiableList(new ArrayList<CaptureStage>(captureStageList));
        }

        @Override
        public List<CaptureStage> getCaptureStages() {
            return this.mCaptureStageList;
        }
    }
}

