/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.RetryPolicy;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.QuirkSettings;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.TargetConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CameraXConfig
implements TargetConfig<CameraX> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int CAMERAX_CONFIG_IMPL_TYPE_UNKNOWN = -1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int CAMERAX_CONFIG_IMPL_TYPE_CAMERA_CAMERA2 = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int CAMERAX_CONFIG_IMPL_TYPE_PIPE = 1;
    static final Config.Option<CameraFactory.Provider> OPTION_CAMERA_FACTORY_PROVIDER = Config.Option.create("camerax.core.appConfig.cameraFactoryProvider", CameraFactory.Provider.class);
    static final Config.Option<CameraDeviceSurfaceManager.Provider> OPTION_DEVICE_SURFACE_MANAGER_PROVIDER = Config.Option.create("camerax.core.appConfig.deviceSurfaceManagerProvider", CameraDeviceSurfaceManager.Provider.class);
    static final Config.Option<UseCaseConfigFactory.Provider> OPTION_USECASE_CONFIG_FACTORY_PROVIDER = Config.Option.create("camerax.core.appConfig.useCaseConfigFactoryProvider", UseCaseConfigFactory.Provider.class);
    static final Config.Option<Executor> OPTION_CAMERA_EXECUTOR = Config.Option.create("camerax.core.appConfig.cameraExecutor", Executor.class);
    static final Config.Option<Handler> OPTION_SCHEDULER_HANDLER = Config.Option.create("camerax.core.appConfig.schedulerHandler", Handler.class);
    static final Config.Option<Integer> OPTION_MIN_LOGGING_LEVEL = Config.Option.create("camerax.core.appConfig.minimumLoggingLevel", Integer.TYPE);
    static final Config.Option<CameraSelector> OPTION_AVAILABLE_CAMERAS_LIMITER = Config.Option.create("camerax.core.appConfig.availableCamerasLimiter", CameraSelector.class);
    static final Config.Option<Long> OPTION_CAMERA_OPEN_RETRY_MAX_TIMEOUT_IN_MILLIS_WHILE_RESUMING = Config.Option.create("camerax.core.appConfig.cameraOpenRetryMaxTimeoutInMillisWhileResuming", Long.TYPE);
    @OptIn(markerClass={ExperimentalRetryPolicy.class})
    static final Config.Option<RetryPolicy> OPTION_CAMERA_PROVIDER_INIT_RETRY_POLICY = Config.Option.create("camerax.core.appConfig.cameraProviderInitRetryPolicy", RetryPolicy.class);
    static final long DEFAULT_OPTION_CAMERA_OPEN_RETRY_MAX_TIMEOUT_IN_MILLIS_WHILE_RESUMING = -1L;
    static final Config.Option<QuirkSettings> OPTION_QUIRK_SETTINGS = Config.Option.create("camerax.core.appConfig.quirksSettings", QuirkSettings.class);
    static final Config.Option<Integer> OPTION_CONFIG_IMPL_TYPE = Config.Option.create("camerax.core.appConfig.configImplType", Integer.TYPE);
    static final Config.Option<Boolean> OPTION_REPEATING_STREAM_FORCED = Config.Option.create("camerax.core.appConfig.repeatingStreamForced", Boolean.TYPE);
    private final OptionsBundle mConfig;

    CameraXConfig(OptionsBundle options) {
        this.mConfig = options;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public  @Nullable CameraFactory.Provider getCameraFactoryProvider( @Nullable CameraFactory.Provider valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_CAMERA_FACTORY_PROVIDER, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public  @Nullable CameraDeviceSurfaceManager.Provider getDeviceSurfaceManagerProvider( @Nullable CameraDeviceSurfaceManager.Provider valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_DEVICE_SURFACE_MANAGER_PROVIDER, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public  @Nullable UseCaseConfigFactory.Provider getUseCaseConfigFactoryProvider( @Nullable UseCaseConfigFactory.Provider valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_USECASE_CONFIG_FACTORY_PROVIDER, valueIfMissing);
    }

    public @Nullable Executor getCameraExecutor(@Nullable Executor valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_CAMERA_EXECUTOR, valueIfMissing);
    }

    public @Nullable Handler getSchedulerHandler(@Nullable Handler valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_SCHEDULER_HANDLER, valueIfMissing);
    }

    public int getMinimumLoggingLevel() {
        return this.mConfig.retrieveOption(OPTION_MIN_LOGGING_LEVEL, 3);
    }

    public @Nullable CameraSelector getAvailableCamerasLimiter(@Nullable CameraSelector valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_AVAILABLE_CAMERAS_LIMITER, valueIfMissing);
    }

    public long getCameraOpenRetryMaxTimeoutInMillisWhileResuming() {
        return this.mConfig.retrieveOption(OPTION_CAMERA_OPEN_RETRY_MAX_TIMEOUT_IN_MILLIS_WHILE_RESUMING, -1L);
    }

    @ExperimentalRetryPolicy
    public @NonNull RetryPolicy getCameraProviderInitRetryPolicy() {
        return Objects.requireNonNull(this.mConfig.retrieveOption(OPTION_CAMERA_PROVIDER_INIT_RETRY_POLICY, RetryPolicy.DEFAULT));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isRepeatingStreamForced() {
        return this.mConfig.retrieveOption(OPTION_REPEATING_STREAM_FORCED, true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable QuirkSettings getQuirkSettings() {
        return this.mConfig.retrieveOption(OPTION_QUIRK_SETTINGS, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getConfigImplType() {
        return this.mConfig.retrieveOption(OPTION_CONFIG_IMPL_TYPE, -1);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull Config getConfig() {
        return this.mConfig;
    }

    public static final class Builder
    implements TargetConfig.Builder<CameraX, Builder> {
        private final MutableOptionsBundle mMutableConfig;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(CameraX.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)CameraX.class);
        }

        public static @NonNull Builder fromConfig(@NonNull CameraXConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setCameraFactoryProvider( @NonNull CameraFactory.Provider cameraFactory) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_FACTORY_PROVIDER, cameraFactory);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setDeviceSurfaceManagerProvider( @NonNull CameraDeviceSurfaceManager.Provider surfaceManagerProvider) {
            this.getMutableConfig().insertOption(OPTION_DEVICE_SURFACE_MANAGER_PROVIDER, surfaceManagerProvider);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setUseCaseConfigFactoryProvider( @NonNull UseCaseConfigFactory.Provider configFactoryProvider) {
            this.getMutableConfig().insertOption(OPTION_USECASE_CONFIG_FACTORY_PROVIDER, configFactoryProvider);
            return this;
        }

        public @NonNull Builder setCameraExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_EXECUTOR, executor);
            return this;
        }

        public @NonNull Builder setSchedulerHandler(@NonNull Handler handler) {
            this.getMutableConfig().insertOption(OPTION_SCHEDULER_HANDLER, handler);
            return this;
        }

        public @NonNull Builder setMinimumLoggingLevel(@IntRange(from=3L, to=6L) int logLevel) {
            this.getMutableConfig().insertOption(OPTION_MIN_LOGGING_LEVEL, logLevel);
            return this;
        }

        public @NonNull Builder setAvailableCamerasLimiter(@NonNull CameraSelector availableCameraSelector) {
            this.getMutableConfig().insertOption(OPTION_AVAILABLE_CAMERAS_LIMITER, availableCameraSelector);
            return this;
        }

        public @NonNull Builder setCameraOpenRetryMaxTimeoutInMillisWhileResuming(long maxTimeoutInMillis) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_OPEN_RETRY_MAX_TIMEOUT_IN_MILLIS_WHILE_RESUMING, maxTimeoutInMillis);
            return this;
        }

        @ExperimentalRetryPolicy
        public @NonNull Builder setCameraProviderInitRetryPolicy(@NonNull RetryPolicy retryPolicy) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_PROVIDER_INIT_RETRY_POLICY, retryPolicy);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setRepeatingStreamForced(boolean forced) {
            this.getMutableConfig().insertOption(OPTION_REPEATING_STREAM_FORCED, forced);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setQuirkSettings(@NonNull QuirkSettings quirkSettings) {
            this.getMutableConfig().insertOption(OPTION_QUIRK_SETTINGS, quirkSettings);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        public @NonNull CameraXConfig build() {
            return new CameraXConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setTargetClass(@NonNull Class<CameraX> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder setConfigImplType(int configImplType) {
            this.getMutableConfig().insertOption(OPTION_CONFIG_IMPL_TYPE, configImplType);
            return this;
        }
    }

    public static interface Provider {
        public @NonNull CameraXConfig getCameraXConfig();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImplType {
    }
}

