/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExperimentalLensFacing;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.LensFacingCameraFilter;
import androidx.core.util.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CameraSelector {
    public static final int LENS_FACING_UNKNOWN = -1;
    public static final int LENS_FACING_FRONT = 0;
    public static final int LENS_FACING_BACK = 1;
    @ExperimentalLensFacing
    public static final int LENS_FACING_EXTERNAL = 2;
    public static final @NonNull CameraSelector DEFAULT_FRONT_CAMERA = new Builder().requireLensFacing(0).build();
    public static final @NonNull CameraSelector DEFAULT_BACK_CAMERA = new Builder().requireLensFacing(1).build();
    private final @NonNull LinkedHashSet<CameraFilter> mCameraFilterSet;
    private final @Nullable String mPhysicalCameraId;

    CameraSelector(@NonNull LinkedHashSet<CameraFilter> cameraFilterSet, @Nullable String physicalCameraId) {
        this.mCameraFilterSet = cameraFilterSet;
        this.mPhysicalCameraId = physicalCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull CameraInternal select(@NonNull LinkedHashSet<CameraInternal> cameras) {
        Iterator cameraInternalIterator = this.filter(cameras).iterator();
        if (cameraInternalIterator.hasNext()) {
            return (CameraInternal)cameraInternalIterator.next();
        }
        String errorMessage = String.format("No available camera can be found. %s %s", this.logCameras(cameras), this.logSelector());
        throw new IllegalArgumentException(errorMessage);
    }

    private String logCameras(@NonNull Set<CameraInternal> cameras) {
        StringBuilder sb = new StringBuilder();
        sb.append("Cams:").append(cameras.size());
        for (CameraInternal camera : cameras) {
            CameraInfoInternal info = camera.getCameraInfoInternal();
            sb.append(String.format(" Id:%s  Lens:%s", info.getCameraId(), info.getLensFacing()));
        }
        return sb.toString();
    }

    private String logSelector() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("PhyId:%s  Filters:%s", this.mPhysicalCameraId, this.mCameraFilterSet.size()));
        for (CameraFilter filter : this.mCameraFilterSet) {
            sb.append(" Id:").append(filter.getIdentifier());
            if (!(filter instanceof LensFacingCameraFilter)) continue;
            sb.append(" LensFilter:").append(((LensFacingCameraFilter)filter).getLensFacing());
        }
        return sb.toString();
    }

    public @NonNull List<CameraInfo> filter(@NonNull List<CameraInfo> cameraInfos) {
        List<CameraInfo> output = new ArrayList<CameraInfo>(cameraInfos);
        for (CameraFilter filter : this.mCameraFilterSet) {
            output = filter.filter(Collections.unmodifiableList(output));
        }
        output.retainAll(cameraInfos);
        return output;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull LinkedHashSet<CameraInternal> filter(@NonNull LinkedHashSet<CameraInternal> cameras) {
        ArrayList<CameraInfo> input = new ArrayList<CameraInfo>();
        for (CameraInternal camera : cameras) {
            input.add(camera.getCameraInfo());
        }
        List<CameraInfo> result = this.filter(input);
        LinkedHashSet<CameraInternal> output = new LinkedHashSet<CameraInternal>();
        for (CameraInternal camera : cameras) {
            if (!result.contains(camera.getCameraInfo())) continue;
            output.add(camera);
        }
        return output;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull LinkedHashSet<CameraFilter> getCameraFilterSet() {
        return this.mCameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable Integer getLensFacing() {
        Integer currentLensFacing = null;
        for (CameraFilter filter : this.mCameraFilterSet) {
            if (!(filter instanceof LensFacingCameraFilter)) continue;
            Integer newLensFacing = ((LensFacingCameraFilter)filter).getLensFacing();
            if (currentLensFacing == null) {
                currentLensFacing = newLensFacing;
                continue;
            }
            if (currentLensFacing.equals(newLensFacing)) continue;
            throw new IllegalStateException("Multiple conflicting lens facing requirements exist.");
        }
        return currentLensFacing;
    }

    public @Nullable String getPhysicalCameraId() {
        return this.mPhysicalCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @NonNull CameraSelector of(CameraIdentifier ... cameraIdentifiers) {
        if (cameraIdentifiers == null || cameraIdentifiers.length == 0) {
            throw new IllegalArgumentException("At least one CameraIdentifier must be provided.");
        }
        Builder builder = new Builder();
        builder.addCameraFilter(availableCameras -> {
            ArrayList<CameraInfo> result = new ArrayList<CameraInfo>();
            HashSet<CameraIdentifier> seenIdentifiers = new HashSet<CameraIdentifier>();
            block0: for (CameraIdentifier priorityId : cameraIdentifiers) {
                for (CameraInfo cameraInfo : availableCameras) {
                    if (!Objects.equals(cameraInfo.getCameraIdentifier(), priorityId) || seenIdentifiers.contains(priorityId)) continue;
                    result.add(cameraInfo);
                    seenIdentifiers.add(priorityId);
                    continue block0;
                }
            }
            return result;
        });
        return builder.build();
    }

    public static final class Builder {
        private final @NonNull LinkedHashSet<CameraFilter> mCameraFilterSet;
        private @Nullable String mPhysicalCameraId;

        public Builder() {
            this.mCameraFilterSet = new LinkedHashSet();
        }

        private Builder(@NonNull LinkedHashSet<CameraFilter> cameraFilterSet) {
            this.mCameraFilterSet = new LinkedHashSet<CameraFilter>(cameraFilterSet);
        }

        public @NonNull Builder requireLensFacing(int lensFacing) {
            Preconditions.checkState((lensFacing != -1 ? 1 : 0) != 0, (String)"The specified lens facing is invalid.");
            this.mCameraFilterSet.add(new LensFacingCameraFilter(lensFacing));
            return this;
        }

        public @NonNull Builder addCameraFilter(@NonNull CameraFilter cameraFilter) {
            this.mCameraFilterSet.add(cameraFilter);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @NonNull Builder fromSelector(@NonNull CameraSelector cameraSelector) {
            Builder builder = new Builder(cameraSelector.getCameraFilterSet());
            return builder;
        }

        public @NonNull Builder setPhysicalCameraId(@NonNull String physicalCameraId) {
            this.mPhysicalCameraId = physicalCameraId;
            return this;
        }

        public @NonNull CameraSelector build() {
            return new CameraSelector(this.mCameraFilterSet, this.mPhysicalCameraId);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.TYPE_USE, ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
    @Retention(value=RetentionPolicy.SOURCE)
    @OptIn(markerClass={ExperimentalLensFacing.class})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LensFacing {
    }
}

