/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Range;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraState;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.DynamicRanges;
import androidx.camera.core.internal.compat.MediaActionSoundCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface CameraInfo {
    public static final int TORCH_STRENGTH_LEVEL_UNSUPPORTED = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final float INTRINSIC_ZOOM_RATIO_UNKNOWN = 1.0f;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final @NonNull String IMPLEMENTATION_TYPE_UNKNOWN = "<unknown>";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final @NonNull String IMPLEMENTATION_TYPE_CAMERA2 = "androidx.camera.camera2";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final @NonNull String IMPLEMENTATION_TYPE_CAMERA2_LEGACY = "androidx.camera.camera2.legacy";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final @NonNull String IMPLEMENTATION_TYPE_FAKE = "androidx.camera.fake";

    public static boolean mustPlayShutterSound() {
        return MediaActionSoundCompat.mustPlayShutterSound();
    }

    public int getSensorRotationDegrees();

    public int getSensorRotationDegrees(int var1);

    public boolean hasFlashUnit();

    public @NonNull LiveData<Integer> getTorchState();

    public @NonNull LiveData<ZoomState> getZoomState();

    public @NonNull ExposureState getExposureState();

    public @NonNull LiveData<CameraState> getCameraState();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull String getImplementationType();

    public @NonNull CameraSelector getCameraSelector();

    default public int getLensFacing() {
        return -1;
    }

    @FloatRange(from=0.0, fromInclusive=false)
    default public float getIntrinsicZoomRatio() {
        return 1.0f;
    }

    default public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        return false;
    }

    @ExperimentalZeroShutterLag
    default public boolean isZslSupported() {
        return false;
    }

    default public @NonNull Set<Range<Integer>> getSupportedFrameRateRanges() {
        return Collections.emptySet();
    }

    @ExperimentalSessionConfig
    default public @NonNull Set<Range<Integer>> getSupportedFrameRateRanges(@NonNull SessionConfig sessionConfig) {
        return Collections.emptySet();
    }

    default public boolean isLogicalMultiCameraSupported() {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public boolean isPrivateReprocessingSupported() {
        return false;
    }

    default public @NonNull Set<DynamicRange> querySupportedDynamicRanges(@NonNull Set<DynamicRange> candidateDynamicRanges) {
        return DynamicRanges.findAllPossibleMatches(candidateDynamicRanges, Collections.singleton(DynamicRange.SDR));
    }

    default public @NonNull Set<CameraInfo> getPhysicalCameraInfos() {
        return Collections.emptySet();
    }

    @IntRange(from=0L)
    default public int getMaxTorchStrengthLevel() {
        return 0;
    }

    default public @NonNull LiveData<Integer> getTorchStrengthLevel() {
        return new MutableLiveData((Object)0);
    }

    default public boolean isTorchStrengthSupported() {
        return false;
    }

    default public boolean isLowLightBoostSupported() {
        return false;
    }

    default public @NonNull LiveData<Integer> getLowLightBoostState() {
        return new MutableLiveData((Object)-1);
    }

    @ExperimentalSessionConfig
    default public boolean isFeatureGroupSupported(@NonNull SessionConfig sessionConfig) {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    default public @Nullable CameraIdentifier getCameraIdentifier() {
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImplementationType {
    }
}

