/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.AdapterCameraInfo;
import androidx.camera.core.impl.Identifier;
import androidx.core.util.Preconditions;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Landroidx/camera/core/CameraIdentifier;", "", "cameraIds", "", "", "compatibilityId", "Landroidx/camera/core/impl/Identifier;", "<init>", "(Ljava/util/List;Landroidx/camera/core/impl/Identifier;)V", "getCameraIds", "()Ljava/util/List;", "getCompatibilityId", "()Landroidx/camera/core/impl/Identifier;", "internalId", "getInternalId", "()Ljava/lang/String;", "isOf", "", "camera", "Landroidx/camera/core/Camera;", "cameraInfo", "Landroidx/camera/core/CameraInfo;", "equals", "other", "hashCode", "", "toString", "Companion", "camera-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCameraIdentifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraIdentifier.kt\nandroidx/camera/core/CameraIdentifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class CameraIdentifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> cameraIds;
    @Nullable
    private final Identifier compatibilityId;

    private CameraIdentifier(List<String> cameraIds, Identifier compatibilityId) {
        this.cameraIds = cameraIds;
        this.compatibilityId = compatibilityId;
        Preconditions.checkArgument((!((Collection)this.cameraIds).isEmpty() ? 1 : 0) != 0, (Object)"Camera ID set cannot be empty.");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final List<String> getCameraIds() {
        return this.cameraIds;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Identifier getCompatibilityId() {
        return this.compatibilityId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getInternalId() {
        Preconditions.checkState((this.cameraIds.size() == 1 ? 1 : 0) != 0, (String)"getInternalId() is only available for single-camera identifiers.");
        return (String)CollectionsKt.first(this.cameraIds);
    }

    public final boolean isOf(@NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Preconditions.checkNotNull((Object)camera);
        return Intrinsics.areEqual((Object)this, (Object)camera.getCameraInfo().getCameraIdentifier());
    }

    public final boolean isOf(@NotNull CameraInfo cameraInfo) {
        Intrinsics.checkNotNullParameter((Object)cameraInfo, (String)"cameraInfo");
        Preconditions.checkNotNull((Object)cameraInfo);
        return Intrinsics.areEqual((Object)this, (Object)cameraInfo.getCameraIdentifier());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CameraIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.cameraIds, ((CameraIdentifier)other).cameraIds)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.compatibilityId, (Object)((CameraIdentifier)other).compatibilityId);
    }

    public int hashCode() {
        int result = ((Object)this.cameraIds).hashCode();
        Identifier identifier = this.compatibilityId;
        result = 31 * result + (identifier != null ? identifier.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                stringBuilder = new StringBuilder().append("CameraIdentifier{cameraIds=").append(CollectionsKt.joinToString$default((Iterable)this.cameraIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                object = this.compatibilityId;
                if (object == null) break block2;
                Identifier it = object;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                String string = ", compatId=" + it;
                stringBuilder = stringBuilder2;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return stringBuilder.append((String)object).append('}').toString();
    }

    @JvmStatic
    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final CameraIdentifier create(@NotNull List<String> cameraIds, @Nullable Identifier compatibilityId) {
        return Companion.create(cameraIds, compatibilityId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CameraIdentifier create(@NotNull String primaryCameraId, @Nullable String secondaryCameraId, @Nullable Identifier compatibilityId) {
        return Companion.create(primaryCameraId, secondaryCameraId, compatibilityId);
    }

    @JvmStatic
    @NotNull
    public static final CameraIdentifier fromAdapterInfos(@NotNull AdapterCameraInfo primaryInfo, @Nullable AdapterCameraInfo secondaryInfo) {
        return Companion.fromAdapterInfos(primaryInfo, secondaryInfo);
    }

    @JvmStatic
    @VisibleForTesting
    @JvmOverloads
    @NotNull
    public static final CameraIdentifier create(@NotNull List<String> cameraIds) {
        return Companion.create(cameraIds);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CameraIdentifier create(@NotNull String primaryCameraId, @Nullable String secondaryCameraId) {
        return Companion.create(primaryCameraId, secondaryCameraId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CameraIdentifier create(@NotNull String primaryCameraId) {
        return Companion.create(primaryCameraId);
    }

    public /* synthetic */ CameraIdentifier(List cameraIds, Identifier compatibilityId, DefaultConstructorMarker $constructor_marker) {
        this(cameraIds, compatibilityId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007\u00a8\u0006\u0011"}, d2={"Landroidx/camera/core/CameraIdentifier$Companion;", "", "<init>", "()V", "create", "Landroidx/camera/core/CameraIdentifier;", "cameraIds", "", "", "compatibilityId", "Landroidx/camera/core/impl/Identifier;", "primaryCameraId", "secondaryCameraId", "fromAdapterInfos", "primaryInfo", "Landroidx/camera/core/impl/AdapterCameraInfo;", "secondaryInfo", "camera-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nCameraIdentifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraIdentifier.kt\nandroidx/camera/core/CameraIdentifier$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @JvmOverloads
        @NotNull
        public final CameraIdentifier create(@NotNull List<String> cameraIds, @Nullable Identifier compatibilityId) {
            Intrinsics.checkNotNullParameter(cameraIds, (String)"cameraIds");
            return new CameraIdentifier(cameraIds, compatibilityId, null);
        }

        public static /* synthetic */ CameraIdentifier create$default(Companion companion, List list, Identifier identifier, int n, Object object) {
            if ((n & 2) != 0) {
                identifier = null;
            }
            return companion.create(list, identifier);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CameraIdentifier create(@NotNull String primaryCameraId, @Nullable String secondaryCameraId, @Nullable Identifier compatibilityId) {
            List cameraIds;
            block0: {
                Intrinsics.checkNotNullParameter((Object)primaryCameraId, (String)"primaryCameraId");
                Object[] objectArray = new String[]{primaryCameraId};
                cameraIds = CollectionsKt.mutableListOf((Object[])objectArray);
                String string = secondaryCameraId;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                cameraIds.add(it);
            }
            return this.create(cameraIds, compatibilityId);
        }

        public static /* synthetic */ CameraIdentifier create$default(Companion companion, String string, String string2, Identifier identifier, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                identifier = null;
            }
            return companion.create(string, string2, identifier);
        }

        @JvmStatic
        @NotNull
        public final CameraIdentifier fromAdapterInfos(@NotNull AdapterCameraInfo primaryInfo, @Nullable AdapterCameraInfo secondaryInfo) {
            Intrinsics.checkNotNullParameter((Object)primaryInfo, (String)"primaryInfo");
            AdapterCameraInfo adapterCameraInfo = secondaryInfo;
            String secondaryId = adapterCameraInfo != null ? adapterCameraInfo.getCameraId() : null;
            Identifier identifier = primaryInfo.getCameraConfig().getCompatibilityId();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getCompatibilityId(...)");
            Identifier compatId = identifier;
            String string = primaryInfo.getCameraId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCameraId(...)");
            return this.create(string, secondaryId, compatId);
        }

        @JvmStatic
        @VisibleForTesting
        @JvmOverloads
        @NotNull
        public final CameraIdentifier create(@NotNull List<String> cameraIds) {
            Intrinsics.checkNotNullParameter(cameraIds, (String)"cameraIds");
            return androidx.camera.core.CameraIdentifier$Companion.create$default(this, cameraIds, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CameraIdentifier create(@NotNull String primaryCameraId, @Nullable String secondaryCameraId) {
            Intrinsics.checkNotNullParameter((Object)primaryCameraId, (String)"primaryCameraId");
            return androidx.camera.core.CameraIdentifier$Companion.create$default(this, primaryCameraId, secondaryCameraId, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CameraIdentifier create(@NotNull String primaryCameraId) {
            Intrinsics.checkNotNullParameter((Object)primaryCameraId, (String)"primaryCameraId");
            return androidx.camera.core.CameraIdentifier$Companion.create$default(this, primaryCameraId, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

