/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageProcessor;
import androidx.camera.core.SurfaceProcessor;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.camera.core.processing.SurfaceProcessorWithExecutor;
import androidx.camera.core.processing.TargetUtils;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class CameraEffect {
    public static final int PREVIEW = 1;
    public static final int VIDEO_CAPTURE = 2;
    public static final int IMAGE_CAPTURE = 4;
    private static final List<Integer> SURFACE_PROCESSOR_TARGETS = Arrays.asList(1, 2, 3, 7);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int TRANSFORMATION_ARBITRARY = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int TRANSFORMATION_CAMERA_AND_SURFACE_ROTATION = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int TRANSFORMATION_PASSTHROUGH = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int OUTPUT_OPTION_ONE_FOR_ALL_TARGETS = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int OUTPUT_OPTION_ONE_FOR_EACH_TARGET = 1;
    private final int mTargets;
    private final int mOutputOption;
    private final int mTransformation;
    private final @NonNull Executor mExecutor;
    private final @Nullable SurfaceProcessor mSurfaceProcessor;
    private final @Nullable ImageProcessor mImageProcessor;
    private final @NonNull Consumer<Throwable> mErrorListener;

    protected CameraEffect(int targets, @NonNull Executor executor, @NonNull ImageProcessor imageProcessor, @NonNull Consumer<Throwable> errorListener) {
        Preconditions.checkArgument((targets == 4 ? 1 : 0) != 0, (Object)"Currently ImageProcessor can only target IMAGE_CAPTURE.");
        this.mTargets = targets;
        this.mTransformation = 0;
        this.mOutputOption = 0;
        this.mExecutor = executor;
        this.mSurfaceProcessor = null;
        this.mImageProcessor = imageProcessor;
        this.mErrorListener = errorListener;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected CameraEffect(int targets, int transformation, @NonNull Executor executor, @NonNull SurfaceProcessor surfaceProcessor, @NonNull Consumer<Throwable> errorListener) {
        this(targets, 0, transformation, executor, surfaceProcessor, errorListener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected CameraEffect(int targets, int outputOption, int transformation, @NonNull Executor executor, @NonNull SurfaceProcessor surfaceProcessor, @NonNull Consumer<Throwable> errorListener) {
        TargetUtils.checkSupportedTargets(SURFACE_PROCESSOR_TARGETS, targets);
        this.mTargets = targets;
        this.mOutputOption = outputOption;
        this.mTransformation = transformation;
        this.mExecutor = executor;
        this.mSurfaceProcessor = surfaceProcessor;
        this.mImageProcessor = null;
        this.mErrorListener = errorListener;
    }

    protected CameraEffect(int targets, @NonNull Executor executor, @NonNull SurfaceProcessor surfaceProcessor, @NonNull Consumer<Throwable> errorListener) {
        this(targets, 0, 0, executor, surfaceProcessor, errorListener);
    }

    public int getTargets() {
        return this.mTargets;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getTransformation() {
        return this.mTransformation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getOutputOption() {
        return this.mOutputOption;
    }

    public @NonNull Executor getExecutor() {
        return this.mExecutor;
    }

    public @NonNull Consumer<Throwable> getErrorListener() {
        return this.mErrorListener;
    }

    public @Nullable SurfaceProcessor getSurfaceProcessor() {
        return this.mSurfaceProcessor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable ImageProcessor getImageProcessor() {
        return this.mImageProcessor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull SurfaceProcessorInternal createSurfaceProcessorInternal() {
        return new SurfaceProcessorWithExecutor(this);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Formats {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface OutputOptions {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Targets {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Transformations {
    }
}

