/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jspecify.annotations.NonNull;

public interface CameraControl {
    public @NonNull ListenableFuture<Void> enableTorch(boolean var1);

    default public @NonNull ListenableFuture<Void> enableLowLightBoostAsync(boolean lowLightBoost) {
        return Futures.immediateFailedFuture(new OperationCanceledException("Not supported!"));
    }

    public @NonNull ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction var1);

    public @NonNull ListenableFuture<Void> cancelFocusAndMetering();

    public @NonNull ListenableFuture<Void> setZoomRatio(float var1);

    public @NonNull ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float var1);

    public @NonNull ListenableFuture<Integer> setExposureCompensationIndex(int var1);

    default public @NonNull ListenableFuture<Void> setTorchStrengthLevel(@IntRange(from=1L) int torchStrengthLevel) {
        return Futures.immediateFailedFuture(new UnsupportedOperationException("Setting torch strength is not supported on the device."));
    }

    public static final class OperationCanceledException
    extends Exception {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OperationCanceledException(@NonNull String message) {
            super(message);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OperationCanceledException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }
    }
}

