/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.util.Size;
import androidx.camera.core.ResolutionInfo;
import org.jspecify.annotations.NonNull;

final class AutoValue_ResolutionInfo_ResolutionInfoInternal
extends ResolutionInfo.ResolutionInfoInternal {
    private final @NonNull Size resolution;
    private final @NonNull Rect cropRect;
    private final int rotationDegrees;

    private AutoValue_ResolutionInfo_ResolutionInfoInternal(@NonNull Size resolution, @NonNull Rect cropRect, int rotationDegrees) {
        this.resolution = resolution;
        this.cropRect = cropRect;
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    @NonNull Size getResolution() {
        return this.resolution;
    }

    @Override
    @NonNull Rect getCropRect() {
        return this.cropRect;
    }

    @Override
    int getRotationDegrees() {
        return this.rotationDegrees;
    }

    public String toString() {
        return "ResolutionInfoInternal{resolution=" + this.resolution + ", cropRect=" + this.cropRect + ", rotationDegrees=" + this.rotationDegrees + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResolutionInfo.ResolutionInfoInternal) {
            ResolutionInfo.ResolutionInfoInternal that = (ResolutionInfo.ResolutionInfoInternal)o;
            return this.resolution.equals((Object)that.getResolution()) && this.cropRect.equals((Object)that.getCropRect()) && this.rotationDegrees == that.getRotationDegrees();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.cropRect.hashCode();
        h$ *= 1000003;
        return h$ ^= this.rotationDegrees;
    }

    static final class Builder
    extends ResolutionInfo.ResolutionInfoInternal.Builder {
        private @NonNull Size resolution;
        private @NonNull Rect cropRect;
        private Integer rotationDegrees;

        Builder() {
        }

        @Override
        ResolutionInfo.ResolutionInfoInternal.Builder setResolution(@NonNull Size resolution) {
            if (resolution == null) {
                throw new NullPointerException("Null resolution");
            }
            this.resolution = resolution;
            return this;
        }

        @Override
        ResolutionInfo.ResolutionInfoInternal.Builder setCropRect(@NonNull Rect cropRect) {
            if (cropRect == null) {
                throw new NullPointerException("Null cropRect");
            }
            this.cropRect = cropRect;
            return this;
        }

        @Override
        ResolutionInfo.ResolutionInfoInternal.Builder setRotationDegrees(int rotationDegrees) {
            this.rotationDegrees = rotationDegrees;
            return this;
        }

        @Override
        ResolutionInfo.ResolutionInfoInternal build() {
            String missing = "";
            if (this.resolution == null) {
                missing = missing + " resolution";
            }
            if (this.cropRect == null) {
                missing = missing + " cropRect";
            }
            if (this.rotationDegrees == null) {
                missing = missing + " rotationDegrees";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ResolutionInfo_ResolutionInfoInternal(this.resolution, this.cropRect, this.rotationDegrees);
        }
    }
}

