/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.Image;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.impl.TagBundle;
import java.nio.ByteBuffer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class AndroidImageProxy
implements ImageProxy {
    private final Image mImage;
    private final PlaneProxy[] mPlanes;
    private final ImageInfo mImageInfo;

    AndroidImageProxy(@NonNull Image image) {
        this.mImage = image;
        Image.Plane[] originalPlanes = image.getPlanes();
        if (originalPlanes != null) {
            this.mPlanes = new PlaneProxy[originalPlanes.length];
            for (int i = 0; i < originalPlanes.length; ++i) {
                this.mPlanes[i] = new PlaneProxy(originalPlanes[i]);
            }
        } else {
            this.mPlanes = new PlaneProxy[0];
        }
        this.mImageInfo = ImmutableImageInfo.create(TagBundle.emptyBundle(), image.getTimestamp(), 0, new Matrix(), 0);
    }

    @Override
    public void close() {
        this.mImage.close();
    }

    @Override
    public @NonNull Rect getCropRect() {
        return this.mImage.getCropRect();
    }

    @Override
    public void setCropRect(@Nullable Rect rect) {
        this.mImage.setCropRect(rect);
    }

    @Override
    public int getFormat() {
        return this.mImage.getFormat();
    }

    @Override
    public int getHeight() {
        return this.mImage.getHeight();
    }

    @Override
    public int getWidth() {
        return this.mImage.getWidth();
    }

    @Override
    public ImageProxy.PlaneProxy @NonNull [] getPlanes() {
        return this.mPlanes;
    }

    @Override
    public @NonNull ImageInfo getImageInfo() {
        return this.mImageInfo;
    }

    @Override
    @ExperimentalGetImage
    public Image getImage() {
        return this.mImage;
    }

    private static final class PlaneProxy
    implements ImageProxy.PlaneProxy {
        private final Image.Plane mPlane;

        PlaneProxy(Image.Plane plane) {
            this.mPlane = plane;
        }

        @Override
        public int getRowStride() {
            return this.mPlane.getRowStride();
        }

        @Override
        public int getPixelStride() {
            return this.mPlane.getPixelStride();
        }

        @Override
        public @NonNull ByteBuffer getBuffer() {
            return this.mPlane.getBuffer();
        }
    }
}

